var TRBLMaker = (function () {

    var _gui,
        _interaction;

    function start() {

        _gui = new TRBLMaker.GUI();

    }

    function soundAvailable(){
        _interaction = new TRBLMaker.Interaction();
        _gui.specialInit()
    }

    return {
        start:start,
        soundAvailable:soundAvailable
    };
}());// mog
/*jslint devel: true, browser: true */
"use strict";

// http://paulirish.com/2011/requestanimationframe-for-smart-animating/
// http://my.opera.com/emoller/blog/2011/12/20/requestanimationframe-for-smart-er-animating

// requestAnimationFrame polyfill by Erik Möller
// fixes from Paul Irish and Tino Zijdel
(function() {
    var lastTime = 0;
    var vendors = ['ms', 'moz', 'webkit', 'o'];
    for(var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
        window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
        window.cancelAnimationFrame = window[vendors[x]+'CancelAnimationFrame']
                                   || window[vendors[x]+'CancelRequestAnimationFrame'];
    }

    if (!window.requestAnimationFrame)
        window.requestAnimationFrame = function(callback, element) {
            var currTime = new Date().getTime();
            var timeToCall = Math.max(0, 16 - (currTime - lastTime));
            var id = window.setTimeout(function() { callback(currTime + timeToCall); },
              timeToCall);
            lastTime = currTime + timeToCall;
            return id;
        };

    if (!window.cancelAnimationFrame)
        window.cancelAnimationFrame = function(id) {
            clearTimeout(id);
        };
}());

//http://gizma.com/easing/
Math.easeOutQuad = function (t, b, c, d) {
    t /= d;
    return -c * t*(t-2) + b;
};

function hashFromString(string) {

    var hash = 0;

    for (var i = 0; i < string.length; i++) {
        hash = string.charCodeAt(i) + ((hash << 5) - hash);
    }

    return Math.abs(hash);
}

function droidColor(hexColor) {

    var hex = (hexColor + '').split(''),
        i = 0;

    for (; i < 6; i += 2) {

        if ((hex[i + 2] === undefined) && (i < 4)) {
            hex[i + 2] = 0;
        }

        hex[i] = parseInt(hex[i], 16);

        if (i < 2) {
            hex[i] = (hex[i] % 3) > 0 ? ((hex[i] % 3) * 3).toString(16) : hex[i].toString(16);
        }

        hex[i] = (hex[i]+ '').length > 1 ? (hex[i]).toString(16) : hex[i];
        hex[i + 1] = hex[i];
    }

    var sixDigits = hex.slice(0, 6);
    return '#' + sixDigits.join('');
}// mog
/*jslint devel: true, browser: true */
TRBLMaker.AudioTools = (function () {
    "use strict";

    var _request,
        _aCtx;

    function load(url) {

        if (url) {

            try {
                _aCtx = new webkitAudioContext();

            } catch (event) {

                throw "[Error] Calling webkitAudioContext failed.";
            }

            _request = new XMLHttpRequest();

            _request.open('GET', url, true);

            _request.responseType = 'arraybuffer';

            _request.addEventListener('load', onLoad);

            _request.send();
        }
    }

    function onLoad(event) {

        console.log('AudioTools:', event);

        _aCtx.decodeAudioData(

            _request.response, function (buffer) {

                getWaveformArray(buffer.getChannelData(0), 1024);
            }
        );
    }

    /*
     targetWidth
     The result might be smaller or bigger, as we need to have a power of two value to step through FFT
     */
    function getWaveformArray(buffer, targetWidth) {

        var FFT_SIZE = 512,
            HEIGHT_SCALE = (128 * 2),
            floatView = new Float32Array(buffer),
            _ctx = (document.getElementById('slut')).getContext('2d'),
            fft,
            max,
            min,
            dist,
            spectrum,
            graphWidth = targetWidth || 300;

        //get nearest power of two value
        FFT_SIZE = Math.pow(2, Math.round(Math.log(floatView.length / graphWidth) / Math.log(2)));

        fft = new FFT(FFT_SIZE, 44100);

        for (var s = 0; s < floatView.length; s += FFT_SIZE) {

            var signal = [];
            //get a sclice of the whole buffer
            for (var i = s; i < s + FFT_SIZE; i++) {

                signal.push(floatView[i]);
            }

            //magic, don't touch
            fft.forward(signal);
            spectrum = fft.spectrum;

            max = 0;
            min = 256;

            for (var c = 0; c < spectrum.length; c++) {

                if (!isNaN(spectrum[c])) {
                    max = spectrum[c] > max ? spectrum[c] : max;
                    min = spectrum[c] < min ? spectrum[c] : min;
                }
            }

            dist = HEIGHT_SCALE * ((max - min));
            dist = dist < 0 ? 0 : dist;

            _ctx.fillRect(xPos, 300 - dist, 1, dist);
            xPos++;
        }
    }

    return {
        load:load
    };

}());// mog
/*jslint devel: true, browser: true */
TRBLMaker.Interaction = (function () {

    var _audio;

    init();

    function keyHandler(event) {

        var SPACEBAR = 32,
            ESC = 27,
            M = 77;

        switch (event.keyCode) {

            case SPACEBAR:
                sync();
                break;

            case ESC:
                togglePause();
                break;

            case M:
                toggleMute();
                break;
        }
    }

    function sync() {

        console.log('[Beat] ', JSON.stringify(Demo.sceneController().getTiming()));
    }

    function togglePause() {

        if (_audio.isPaused()) {
            _audio.play();
            //window.requestAnimationFrame(loop, document);
        } else {
            _audio.pause();
        }
    }

    function toggleMute() {

        if (_audio.volume() <= 0) {
            _audio.volume(Demo.model().volume || .5);
        }
        else {
            _audio.volume(0);
        }
    }

    function init() {

        _audio = Demo.audio();

        document.getElementById('root').onkeydown = keyHandler;
    }
});// mog
/*jslint devel: true, browser: true */
TRBLMaker.GUI = (function () {
    "use strict";

    var _holder,
        _fontTex,
        _fpsGUI,
        _beatGUI,
        _timelineGUI,
        _previousTime = 0,
        _fpsTime = 0,
        _fCount = 0,

        pngFont = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEYAAAAFCAMAAADPPGp0AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAZQTFRFMzMz////Iyh/xwAAAEVJREFUeNpiYGAEAwYgAFFQHpwCIQxBLBQDDDNgoeDGIIsj5JDlUdUR4RoGBmyC6Mag2gjTiOIwOIHkTHSlxFmMJggQYACUHADSUbWRfgAAAABJRU5ErkJggg==";

    function fps(tDelta) {

        if (_fpsTime < 1000) {

            _fCount++;
            _fpsTime += tDelta;

        } else {
            _fpsGUI.update(_fCount);

            _fpsTime = 0;
            _fCount = 0;
        }
    }

    function fpsUpdate() {

        window.requestAnimationFrame(fpsUpdate, document);

        fps(Date.now() - _previousTime);
        _previousTime = Date.now();

        _beatGUI.update();
    }

    function start() {

        fpsUpdate();
    }

    function init() {

        _holder = document.createElement("div");
        _holder.setAttribute('id', 'trblDebug');
        _holder.style.cssText = 'position:absolute; top:0; left:0; z-index:1337;';

        _fontTex = document.createElement('img');
        _fontTex.src = pngFont;

        _fpsGUI = new TRBLMaker.GUI.FPS(_holder, _fontTex);
        _beatGUI = new TRBLMaker.GUI.Beat(_holder, _fontTex);


        document.getElementById('root').appendChild(_holder);

        start();
    }

    function specialInit(){
        _timelineGUI = new TRBLMaker.GUI.Timeline(_holder, _fontTex);
    }

    init();

    return {
        specialInit:specialInit
    }
});// mog
/*jslint devel: true, browser: true */
TRBLMaker.GUI.Timeline = (function () {
    "use strict";

    var TIMELINE_WIDTH = 800,
        _sceneList,
        _holder,
        _position,
        _positionTooltip;

    function setSceneList(sceneList) {

        _sceneList = sceneList;
    }

    function toggleShowPosition(event) {

        if (event.type == "mouseout") {
            _positionTooltip.style.display = 'none';
            return;
        }

        if (Demo && Demo.audio() && !isNaN(Demo.audio().position())) {
            var sceneTime = Math.round(Demo.audio().duration() / TIMELINE_WIDTH * event.offsetX * 100) / 100,
                demoTime = Math.round(Demo.audio().duration() / TIMELINE_WIDTH * event.clientX * 100) / 100,
                beat = Math.round(((demoTime / 4) + 1) * 100) / 100;

            _positionTooltip.style.display = 'block';
            _positionTooltip.style.left = event.pageX + 'px';

            _positionTooltip.innerHTML = ['scene:' + sceneTime, 'demo:' + demoTime, 'beat:' + beat].join('<br>');
        }
    }

    function jumpInDemo(event){


        if (Demo && Demo.audio() && !isNaN(Demo.audio().position())) {
            var demoTime = Math.round(Demo.audio().duration() / TIMELINE_WIDTH * event.clientX * 100) / 100;

            Demo.audio().position(demoTime);
        }
    }

    function addListener() {

        _holder.onmouseover = toggleShowPosition;
        _holder.onmouseout = toggleShowPosition;
        _holder.onmousemove = toggleShowPosition;
        _holder.onclick = jumpInDemo;
    }

    function update() {

        window.requestAnimationFrame(update, document);

        if (!isNaN(Demo.audio().position())) {
            var tunePos = Math.round(TIMELINE_WIDTH / Demo.audio().duration() * Demo.audio().position());
            _position.style.left = tunePos + 'px';
        }
    }

    function init() {

        _holder = document.createElement('div');

        var timeLine = document.createElement('div');
        timeLine.style.cssText = 'position:absolute;z-index:1337;float:left;width:' + TIMELINE_WIDTH +
            'px;height:12px;background:#333333;bottom:0;';

        if (Demo) {
            var list = Demo.sceneList(),
                duration = Demo.audio().duration() * 1000;//list[list.length - 1].endTime;

            for (var i = 0; i < list.length; i++) {
                var width = Math.round(TIMELINE_WIDTH / duration * list[i].duration),
                    pos = Math.round(TIMELINE_WIDTH / duration * list[i].startTime),
                    scene = document.createElement('div'),
                    sceneColor = hashFromString((list[i].scene.render).toString());

                scene.style.cssText
                    = 'position:absolute;display:float;height:100%;opacity:.45;border:1px solid rgba(255,255,255, .30);border-right:1px solid rgba(0,0,0, .30);';
                scene.style.cssText += 'width:' + (width - 2) + 'px;' +
                    'background-color:' + droidColor(sceneColor) + ';' +
                    'left:' + pos + 'px;';
                timeLine.appendChild(scene);
            }
        }

        _position = document.createElement('div');
        _position.style.cssText = 'position:absolute;float:left;width:2px;height:100%;background:white;';
        timeLine.appendChild(_position);

        _positionTooltip = document.createElement('div');
        _positionTooltip.id = "tooltip";
        _positionTooltip.style.cssText
            = 'position:absolute;float:left;background-color:#333;bottom:20px;color:#fff;font:10px monospace;padding:4px;display:none;';
        timeLine.appendChild(_positionTooltip);

        addListener();

        _holder.appendChild(timeLine);
        document.getElementById('root').appendChild(_holder);

        //activate showing the progress
        update();
    }

    init();

    return {
        setSceneList:setSceneList,
        update      :update,
        init        :init
    };
});// mog
/*jslint devel: true, browser: true */
TRBLMaker.GUI.FPS = (function (holder, font) {
    "use strict";

    var WIDTH = 48,
        HEIGHT = 48,
        MAX_FPS = 90,
        BG_COLOR = '#333333',
        BAR_COLOR = '#669900',
        GRID_COLOR = 'rgba(238, 238, 238, .5)',
        _holder = holder,
        _fontTex = font,
        _ctx,
        _textCtx;

    init();

    function addLine(fps) {

        var drawHeight = Math.round(HEIGHT / MAX_FPS * fps);

        //move one pixel left
        _ctx.drawImage(_ctx.canvas, 1, 0, WIDTH - 1, HEIGHT, 0, 0, WIDTH - 1, HEIGHT);

        _ctx.save();

        //bg
        _ctx.fillStyle = BG_COLOR;
        _ctx.fillRect(WIDTH - 1, 0, 1, HEIGHT - drawHeight);

        //graph
        _ctx.fillStyle = BAR_COLOR;
        _ctx.fillRect(WIDTH - 1, HEIGHT - drawHeight, 1, drawHeight);

        //grid
        _ctx.fillStyle = GRID_COLOR;
        _ctx.fillRect(WIDTH - 1, HEIGHT - Math.round(HEIGHT / MAX_FPS * 60), 1, 1);
        _ctx.fillRect(WIDTH - 1, HEIGHT - Math.round(HEIGHT / MAX_FPS * 30), 1, 1);
        _ctx.fillRect(WIDTH - 1, HEIGHT - Math.round(HEIGHT / MAX_FPS * 24), 1, 1);

        _ctx.restore();
    }

    function addText(fps) {

        var textX = (_textCtx.canvas.width - 7) - 1,
            textY = 1,
            fpsArr = (fps + '').split(''),
            letter;

        _textCtx.save();
        _textCtx.fillStyle = BG_COLOR;
        _textCtx.fillRect(0, 0, _textCtx.canvas.width, _textCtx.canvas.height);
        _textCtx.restore();

        if (fpsArr.length === 1) {

            fpsArr = [0, fps];
        }

        for (letter = (fpsArr.length - 1); letter >= 0; letter--) {

            _textCtx.drawImage(_fontTex, (fpsArr[letter] * 7), 0, 7, 5, textX, textY, 7, 5);

            textX -= 7;
        }
    }

    function createGraph() {

       var canvas = document.createElement("canvas");
        canvas.width = WIDTH;
        canvas.height = HEIGHT;
        canvas.style.cssText = "float:left;";
        _ctx = canvas.getContext('2d');

        _ctx.save();
        _ctx.fillStyle = BG_COLOR;
        _ctx.fillRect(0, 0, WIDTH, HEIGHT);

        _ctx.fillStyle = GRID_COLOR;
        _ctx.fillRect(0, HEIGHT - Math.round(HEIGHT / MAX_FPS * 60), WIDTH, 1);
        _ctx.fillRect(0, HEIGHT - Math.round(HEIGHT / MAX_FPS * 30), WIDTH, 1);
        _ctx.fillRect(0, HEIGHT - Math.round(HEIGHT / MAX_FPS * 24), WIDTH, 1);
        _ctx.restore();

        _holder.appendChild(canvas);
    }

    function createText() {
        var canvas = document.createElement("canvas");
        canvas.width = 24;
        canvas.height = 8;
        canvas.style.cssText = "float: right;";
        _textCtx = canvas.getContext('2d');
        _holder.appendChild(canvas);
    }

    function update(fps) {
        addLine(fps);
        addText(fps);
    }

    function init() {

        createText();
        createGraph();
    }

    return {
        //init:init,
        update:update
    };
});// mog
/*jslint devel: true, browser: true */
TRBLMaker.GUI.Beat = (function (holder, font) {

    var _holder = holder,
        _fontTex = font,
        _ctx,
        BG_COLOR = '#333333',
        BAR_COLOR = '#669900',
        GRID_COLOR = 'rgba(238, 238, 238, .5)',
        _previousFloatBeat = 0;

    init();

    function createGraph() {

        var canvas = document.createElement("canvas");
        canvas.width = 48;
        canvas.height = 24;
        canvas.style.cssText = "float: left;clear:both;";

        _ctx = canvas.getContext('2d');

        _ctx.save();
        _ctx.fillStyle = BG_COLOR;
        _ctx.fillRect(0, 0, canvas.width, canvas.height);

        _ctx.fillStyle = GRID_COLOR;
        _ctx.fillRect(0, canvas.height - Math.round(canvas.height / 1.2 * .5), canvas.width, 1);
        _ctx.restore();

        _holder.appendChild(canvas);
    }

    function addBeat() {

        var width = _ctx.canvas.width,
            height = _ctx.canvas.height;

        if (Demo.audio()) {

            var floatBeat = Demo.audio().position();
            floatBeat = Math.round(floatBeat * 100) / 100; // round to two digits after comma
            floatBeat = floatBeat - Math.floor(floatBeat); //get real part of number

            if (floatBeat > _previousFloatBeat) {

                var drawHeight = Math.round(height / 1.2 * floatBeat);

                //move one pixel left
                _ctx.drawImage(_ctx.canvas, 1, 0, width - 1, height, 0, 0, width - 1, height);

                _ctx.save();

                //bg
                _ctx.fillStyle = BG_COLOR;
                _ctx.fillRect(width - 1, 0, 1, height - drawHeight);

                //graph
                _ctx.fillStyle = BAR_COLOR;
                _ctx.fillRect(width - 1, height - drawHeight, 1, drawHeight);

                //grid
                _ctx.fillStyle = GRID_COLOR;
                _ctx.fillRect(width - 1, height - Math.round(height / 1.2 * .5), 1, 1);

                _ctx.restore();
            }

            _previousFloatBeat = floatBeat;
        }
    }

    function update() {
        addBeat();
    }

    function init() {
        createGraph();
    }

    return{
        update:update
    }
});var EventDispatcher = (function () {

    var _eventListeners = [];

    return {

        addEventListener:function (event, listener) {

            _eventListeners.push({ event:event, listener:listener });
        },

        removeEventListener:function (event, listener) {

            for (var i = _eventListeners.length - 1; i >= 0; i--) {

                if ((_eventListeners[i].event == event) && (_eventListeners[i].listener == listener)) {
                    _eventListeners.splice(i, 1);
                }
            }
        },

        dispatchEvent:function (event, eventArgs) {

            for (var i = 0; i < _eventListeners.length; i++) {

                var eventListener = _eventListeners[i];

                if (eventListener.event == event && typeof(eventListener.listener) == 'function') {

                    var params = {

                        type:event,
                        info:eventArgs
                    };

                    eventListener.listener(params);
                }
            }
        }
    };
});var Model = (function () {

    "use strict";

    var _cfg,
        _scale = true,
        _width = window.innerWidth,
        _height = window.innerHeight,
        _dispatcher = new EventDispatcher();

    function updateDimension() {

        if (_scale) {
            _width = window.innerWidth;
            _height = window.innerHeight;
        }

        dispatchEvent("model:resize", {'width':_width, 'height':_height});

        console.log("[Model] updateDimension - ", _scale, _width, _height);
    }

    window.onresize = updateDimension;

    function setFromObject(cfg) {

        _cfg = cfg;
    }

    function scale(newScale) {

        if ((newScale === false) || (newScale === true)) {
            _scale = newScale;
        }

        return _scale;
    }

    function width(newWidth) {

        console.log("[Model] width:", newWidth, _width);

        if (!isNaN(newWidth)) {
            _width = newWidth;
        }

        return _width;
    }

    function height(newHeight) {

        console.log("[Model] height:", newHeight, _height);

        if (!isNaN(newHeight)) {
            _height = newHeight;
        }

        return _height;
    }

    function dispatchEvent(event, args) {

        _dispatcher.dispatchEvent(event, args);
    }

    function addEventListener(event, func) {

        _dispatcher.addEventListener(event, func);
    }

    function removeEventListener(event, func) {

        _dispatcher.removeEventListener(event, func);
    }

    return {
        addEventListener   :addEventListener,
        removeEventListener:removeEventListener,
        set                :setFromObject,
        scale              :scale,
        width              :width,
        height             :height
    };
});// mog
/*jslint devel: true, browser: true */
var Audio = (function () {
    "use strict";

    var _audio,
        _url,
        _requestPlay = false,
        _loaded = false,
        _onPlayCallback,
        _isPaused = true;

    function play() {

        _requestPlay = true;
        console.log("Audio.play() " + _audio + '&&' + _loaded);

        if (_audio && _loaded) {

            _audio.play();

            _isPaused = false;
            console.log("Audio._audio && _loaded()");
            if (_onPlayCallback) {
                console.log("Audio._onPlayCallback()");
                _onPlayCallback();
            }
        }
    }

    function onReady() {

        _audio.removeEventListener('canplaythrough', onReady);

        _loaded = true;

        if (_requestPlay === true) {
            play();
        }
    }

    function create(url) {

        _url = url;

        _audio = document.createElement('audio');
        _audio.src = url;
        _audio.addEventListener('canplaythrough', onReady);
        _audio.load();
        _audio.preload = true;
        console.log("create");
    }

    function onPlay(onPlayCallback) {

        _onPlayCallback = onPlayCallback;
    }

    function pause() {

        if (_audio) {
            _audio.pause();
            _isPaused = true;
        }
    }

    function volume(vol) {

        if (_audio && !isNaN(vol)) {
            _audio.volume = vol;
        }

        return _audio.volume;
    }

    function isPaused() {

        return _isPaused;
    }

    function getURL() {

        return _url;
    }

    function position(newPosition) {

        if (_audio) {

            if (newPosition) {
                _audio.currentTime = newPosition;
            }

            return _audio.currentTime;
        }

        return 0;
    }

    function duration() {

        if (_audio && !isNaN(_audio.duration)) {
            return _audio.duration;
        } else {
            return 218.488;
        } //TODO Hardcoded
    }

    return { create:create,
        play:play,
        pause:pause,
        volume:volume,
        position:position,
        duration:duration,
        onPlay:onPlay,
        isPaused:isPaused,
        getURL:getURL
    };
});//mog
/*jslint devel: true, browser: true */
var SceneList = (function (model) {
    "use strict";

    var _model = model,
        _sceneList = [],
        _sceneListBackup = [],
        _bpm = 0,
        _beatOffset = 0,
        _previousBeat,
        _previousMsTime = 0,
        _majorBeat = 1,
        _minorBeat = 1,
        _floatBeat,
        _sTime;

    function setBPM(newBPM) {
        _bpm = newBPM;
    }

    function setBeatOffsetMs(newBeatOffset) {

        if (newBeatOffset < 0) {
            throw("[SceneList] Can't set negative beat offset");
        }

        _beatOffset = (newBeatOffset / 1000);

        console.log("setBeatOffset", _beatOffset);
    }

    function add(scene, startTime, endTime) {

        _sceneList.push({
            'scene'    :scene,
            'startTime':startTime,
            'endTime'  :endTime,
            'duration' :endTime - startTime,
            'active'   :false});

        _sceneListBackup = _sceneList;
    }

    function update(sTime) {

        _floatBeat = (_beatOffset + sTime) * (_bpm / 60);
        _sTime = sTime;

        var i = 0,
            sceneTime,
            msTime = Math.round(sTime * 1000),
            integerBeat = Math.floor(_floatBeat),
            frameDelta = msTime - _previousMsTime;

        _previousMsTime = msTime;

        for (; i < _sceneList.length; i++) {

            if ((msTime > _sceneList[i].endTime) && (_sceneList[i].active === true)) {

                //delete
                _sceneList[i].scene.clear();
                _sceneList.splice(i, 1);

            } else if ((msTime >= _sceneList[i].startTime) && (_sceneList[i].endTime > msTime)) {

                if (_sceneList[i].active === false) {

                    //init
                    _sceneList[i].scene.init(_sceneList[i].duration, _model);
                    _sceneList[i].active = true;
                }

                if (integerBeat != _previousBeat) {

                    _previousBeat = integerBeat;

                    _sceneList[i].scene.onBeat(integerBeat, msTime, _majorBeat, _minorBeat);

                    _minorBeat++;

                    if (_minorBeat > 4) {
                        _majorBeat++;
                        _minorBeat = 1;
                    }

                }

                //render
                sceneTime = msTime - _sceneList[i].startTime;
                _sceneList[i].scene.render(sceneTime, _floatBeat, frameDelta);
            }
        }
    }

    function getList() {

        return _sceneListBackup;
    }

    function getTiming() {
        return {
            'major':_majorBeat,
            'minor':_minorBeat,
            'float':_floatBeat,
            'time' :_sTime
        };
    }

    return {
        add            :add,
        setBPM         :setBPM,
        setBeatOffsetMs:setBeatOffsetMs,
        update         :update,
        getList        :getList,
        getTiming      :getTiming
    };
});// keyj
// mog
/*jslint devel: true, browser: true */
var Random = (function () {
    "use strict";

    var x = 2323233,
        y = 8000085,
        z = 1333337,
        w = 4242424;

    function xor128() {

        var t = x ^ (x << 11);
        x = y;
        y = z;
        z = w;
        w = w ^ (w >>> 19) ^ (t ^ (t >>> 8));
        return (w < 0) ? (w + 4294967296) : w;
    }

    function xor128Float() {

        return (xor128() * (1 / 4294967296));
    }

    function color() {

        return "#" + ((1 << 24) * xor128Float() | 0).toString(16);
    }

    return {
        int:xor128,
        float:xor128Float,
        color:color
    };
}());// mog
/*jslint devel: true, browser: true */

var ImgLoader = (function () {

    "use strict";

    var _resource = [],
        _resourceURL = [],
        _callback,
        _loaded = 0;

    function load(resourceURL, callback) {

        _resourceURL = resourceURL;

        _callback = callback;

        for (var entry in _resourceURL) {

            for (var key in _resourceURL[entry]) {

                var img = document.createElement('img');
                img.onload = loadGuard;
                img.src = _resourceURL[entry][key];

                _resource[key] = img;
            }
        }
    }

    function loadGuard() {

        _loaded++;
        //console.log("loadGuard", _loaded, _resourceURL.length);
        if (_loaded === _resourceURL.length) {

            _callback(_resource);
        }
    }

    return {
        load:load,
        resource:_resource
    };
});// mog
/*jslint devel: true, browser: true */
var Verlet = (function () {

    var verletPoint = (function () {

        var _x,
            _y,
            _oldX,
            _oldY;

        function init(x, y) {
            setPos(x, y);
        }

        function setPos(x, y) {
            _x = x;
            _oldX = x;

            _y = y;
            _oldY = y;
        }

        function refresh() {
            var tempX = _x,
                tempY = _y;

            _x += _x - _oldX;
            _y += _y - _oldY;

            _oldX = tempX;
            _oldY = tempY;
        }

        function getX() {
            return _x;
        }

        function setX(newX) {
            _x = newX;
        }

        function getY() {
            return _y;
        }

        function setY(newY) {
            _y = newY;
        }

        return {
            init    :init,
            setPoint:setPos,
            refresh :refresh,
            getX    :getX,
            setX    :setX,
            getY    :getY,
            setY    :setY
        };
    });

    var verletStick = (function () {
        var _pointA,
            _pointB,
            _hypotenuse;

        function init(a, b) {
            _pointA = a;
            _pointB = b;

            var dX = _pointA.getX() - _pointB.getX();
            var dY = _pointA.getY() - _pointB.getY();

            _hypotenuse = Math.sqrt(dX * dX + dY * dY);
        }

        function contract() {
            var dX = _pointB.getX() - _pointA.getX(),
                dY = _pointB.getY() - _pointA.getY(),
                h = Math.sqrt(dX * dX + dY * dY),
                diff = _hypotenuse - h,
                offsetX = (diff * dX / h) * 0.5,
                offsetY = (diff * dY / h) * 0.5;

            _pointA.setX(_pointA.getX() - offsetX);
            _pointA.setY(_pointA.getY() - offsetY);
            _pointB.setX(_pointB.getX() + offsetX);
            _pointB.setY(_pointB.getY() + offsetY);
        }

        function getPointA() {
            return _pointA;
        }

        function getPointB() {
            return _pointB;
        }

        return {
            init     :init,
            contract :contract,
            getPointA:getPointA,
            getPointB:getPointB
        }
    });

    var verlet = (function () {

        var COLUMNS,
            ROWS,
            STICK_LENGTH,
            FLOPPYNESS,
            COLOR,
            THICKNESS,
            START_X,
            START_Y,
            END_X,
            END_Y,
            _point = [],
            _stick = [],
            _anchorLeft,
            _anchorRight,
            _ctx,
            _weightElement;

        function initialize() {

            var i = 0;

            for (var r = 0; r < ROWS; r++) {

                for (var c = 0; c < COLUMNS; c++) {

                    _point[r * COLUMNS + c] = new verletPoint();
                    _point[r * COLUMNS + c].init(c * STICK_LENGTH, r * STICK_LENGTH);

                    if (c > 0) {

                        var stick = new verletStick();
                        stick.init(_point[r * COLUMNS + c - 1], _point[r * COLUMNS + c]);
                        _stick[i++] = stick;
                    }

                    if (r > 0) {
                        var stick = new verletStick();
                        stick.init(_point[r * COLUMNS + c], _point[(r - 1) * COLUMNS + c]);
                        _stick[i++] = stick;
                    }
                }
            }

            _anchorLeft = {'x':START_X, 'y':START_Y};
            _anchorRight = {'x':START_X + COLUMNS * STICK_LENGTH, 'y':START_Y};

            for (var index = 0; index < _point.length; index++) {
                //_point[index].setPoint(_point[index].getX(), 0);
                if (END_X && END_Y) {
                    _point[index].setPoint(END_X, END_Y);
                } else {
                    _point[index].setPoint(_anchorLeft.x, -_weightElement.width);
                }
            }
        }

        function animate() {

            var i,
                t = _point.length;

            _point[0].setPoint(_anchorLeft.x, _anchorLeft.y);

            if (END_X && END_Y) {
                _point[ROWS * COLUMNS - 1].setPoint(END_X, END_Y);
            } else {
                _point[COLUMNS - 1].setPoint(_anchorRight.x, _anchorRight.y);
            }
        
            for (i = COLUMNS; i < t; i++) {

                _point[i].setY(_point[i].getY() + FLOPPYNESS);
                _point[i].refresh();
            }

            t = _stick.length;

            for (var stiff = 0; stiff < 10; stiff++) {
                for (i = 0; i < t; i++) {
                    _stick[i].contract();
                }
            }
        }

        function drawWeight(pointStart, pointEnd) {

            var angle = Math.atan2(pointStart.getY() - pointEnd.getY(), pointStart.getX() - pointEnd.getX()) * 180 /
                Math.PI;

            var cssText = 'position:absolute;left:' + (pointStart.getX() - _weightElement.width / 2) + 'px;top:' +
                pointStart.getY() + 'px;';
            cssText += '-webkit-transform: rotateZ(' + (angle - 90) + 'deg);';
            cssText += '-webkit-transform-origin: 50% 0;';

            _weightElement.style.cssText = cssText;
        }

        function draw() {

            _ctx.strokeStyle = COLOR;
            _ctx.lineWidth = THICKNESS;
            _ctx.lineCap = 'round';

            for (var i = 0; i < _stick.length; i++) {

                _ctx.beginPath();
                _ctx.moveTo((_stick[i].getPointA()).getX(), _stick[i].getPointA().getY());
                _ctx.lineTo(_stick[i].getPointB().getX(), _stick[i].getPointB().getY());
                _ctx.stroke();
                _ctx.closePath();
            }

            drawWeight(_stick[_stick.length - 1].getPointA(), _stick[_stick.length - 1].getPointB());
        }

        function render() {

            animate();
            draw();
        }

        function setContext(newCTX) {
            _ctx = newCTX;
        }

        function setWeightElement(someDiv) {
            _weightElement = someDiv;
        }

        function init(cfg) {

            if (cfg === undefined) {
                cfg = {};
            }

            COLOR = cfg.color || '#ff0000';
            THICKNESS = cfg.thickness || 2;
            COLUMNS = cfg.columns || 1;
            ROWS = cfg.rows || 20;
            FLOPPYNESS = cfg.floppyness || .3;
            START_X = cfg.startX || 10;
            START_Y = cfg.startY || -10;
            END_X = cfg.endX;
            END_Y = cfg.endY;
            STICK_LENGTH = cfg.stickLength || 10;

            initialize();
        }

        function setEnd(newX, newY){
            END_X = newX;
            END_Y = newY;
        }

        return {
            setDiv          :setDiv,
            setContext      :setContext,
            setEnd          :setEnd,
            setWeightElement:setWeightElement,
            init            :init,
            render          :render
        };
    });

    var v = new verlet();

    function render() {
        v.render();
    }

    function init(cfg) {
        v.init(cfg);
    }

    function setDiv(divElement) {
        v.setWeightElement(divElement);
    }

    function setEnd(newX, newY) {
        v.setEnd(newX, newY);
    }

    function setContext(newContext) {
        v.setContext(newContext);
    }

    return {
        setContext:setContext,
        setDiv    :setDiv,
        setEnd    :setEnd,
        render    :render,
        init      :init
    };
});
// mog
/*jslint devel: true, browser: true */
var Filter = (function () {
    "use strict";

    var _ctx,
        _w,
        _h,
        _imgData,
        _len;

    function setContext(ctx) {

        _ctx = ctx;

        _w = _ctx.canvas.width;
        _h = _ctx.canvas.height;

        _imgData = _ctx.getImageData(0, 0, _w, _h);
        _len = _imgData.data.length;
    }

    function noise() {

        _ctx.putImageData(_imgData, 0, 0);

        for(var i = _len; i > 0; i -= 4) {
            _imgData.data[i + 3] = 50 + Math.round(Math.random() * 20);
        }

        _ctx.putImageData(_imgData, 0, 0);
    }

    return {
        setContext:setContext,
        noise:noise
    };
});// mog
/*jslint devel: true, browser: true */
var Pixel = (function () {
    "use strict";

    var _ctx;

    function setContext(ctx) {

        _ctx = ctx;
    }

    //http://en.wikipedia.org/wiki/Bresenham's_line_algorithm#Simplification
    function line(x0, y0, x1, y1) {

        var dx = Math.abs(x1 - x0),
            sx = x0 < x1 ? 1 : -1,
            dy = -Math.abs(y1 - y0),
            sy = y0 < y1 ? 1 : -1,
            err = dx + dy,
            e2;

        for (; ;) {

            _ctx.fillRect(x0, y0, 1, 1);

            if (x0 == x1 && y0 == y1) {
                break;
            }

            e2 = 2 * err;
            if (e2 > dy) {
                err += dy;
                x0 += sx;
            }

            if (e2 < dx) {
                err += dx;
                y0 += sy;
            }
        }
    }

    function shape(pCloud) {

        if (pCloud.length > 2) {

            var i = 0,
                p = pCloud.slice(0, pCloud.length); //needed deref

            //add first as last again, to close the shape
            p.push(p[0]);

            var len = p.length - 1;
            for (i = 0; i < len; i++) {
                line(Math.round(p[i][0]), Math.round(p[i][1]), Math.round(p[i + 1][0]), Math.round(p[i + 1][1]));
            }
        }
    }

    return {
        setContext:setContext,
        shape:shape,
        line:line
    };
});// mog
/*jslint devel: true, browser: true */
var Starfield = (function () {

    "use strict";

    var PARTICLE_COUNT = 650,
        MAX_PARTICLE_SIZE = 2,
        palette = [ '#0d90bf', '#823aa6'],
        maxZ,
        particles = [],
        _ctx,
        _width,
        _height,
        _speed = 2,
        _centerX,
        _centerY;

    function setContext(ctx) {

        _ctx = ctx;

        _width = _ctx.canvas.width;
        _height = _ctx.canvas.height;

        maxZ = _width - _height;

        _ctx.lineWidth = 1;

        setCenter(_width / 2, _height / 2);
    }

    function setCenter(centerX, centerY){
        _centerX = centerX;
        _centerY = centerY;
    }

    function moveParticle() {

        var halfWidth = _centerX,//_width / 2,
            halfHeight = _centerY,//_height / 2,
            i = 0,
            p,
            newX,
            newY,
            diameter;

        for (i; i < PARTICLE_COUNT; i++) {

            if (particles[i] === undefined) {
                particles[i] = {};
                particles[i].z = -1;
            }

            p = particles[i];

            p.z -= _speed;

            if ((p.z < 0)) {

                p.x = ((Random.float() * halfWidth - 1) + 1) * ((Random.float() * 99) > 50 ? -1 : 1);
                p.y = ((Random.float() * halfHeight - 1) + 1) * ((Random.float() * 99) > 50 ? -1 : 1);
                p.z = Random.float() * (maxZ / 3);

                p.oldX = null;
                p.oldY = null;

                p.color = palette[Math.round(Random.float())];

            } else {

                newX = (halfWidth) + (p.x / p.z) * 50;
                newY = (halfHeight) + (p.y / p.z) * 50;

                if (((newX > 0) && (newX < _width)) && (newY > 0) && (newY < _height)) {

                    var alpha = 0;
                    if (p.z < (maxZ)) {
                        alpha = (maxZ - p.z) / maxZ;
                    }

                    _ctx.globalAlpha = alpha;
                    if (p.oldX) {

                        _ctx.strokeStyle = p.color;


                        _ctx.beginPath();
                        _ctx.moveTo(p.oldX, p.oldY);
                        _ctx.lineTo(newX, newY);
                        _ctx.closePath();
                        _ctx.stroke();
                    }

                    p.oldX = newX;
                    p.oldY = newY;

                } else {

                    p.z = -1;
                }
            }
        }

        _ctx.restore();
    }

    function setSpeed(newSpeed) {
        if (newSpeed) {
            _speed = newSpeed;
        }
    }

    return {
        setContext:setContext,
        render:moveParticle,
        setSpeed:setSpeed,
        setCenter:setCenter
    };
}());