/*
/        kansloos
/
/ Code: the_JinX / deFEEST
/    Distraction: oosjeu
/  Music: Cinder / deFEEST
/ Graphics: Mimi
/        Ranzbak / deFEEST
/
/ Thanks to: http://stemkoski.github.com/Three.js/
/            http://mrdoob.github.com/three.js/
*/

var audioElement = document.createElement('audio'),
	sourceOgg = document.createElement('source'), 
	sourceMp3 = document.createElement('source'),
	sourceWav = document.createElement('source');

sourceOgg.setAttribute('src', 'kansloos.ogg');
sourceMp3.setAttribute('src', 'kansloos.mp3');
sourceMp3.setAttribute('src', 'kansloos.wav');
audioElement.appendChild(sourceOgg);
audioElement.appendChild(sourceMp3);
audioElement.appendChild(sourceWav);

// MAIN
if ( ! Detector.webgl ) Detector.addGetWebGLMessage();
// standard global variables
var container, scene, camera, renderer, controls, stats, part, offset = {x:0, y:0, z:0}, texture, context, gradient, color;
var clock = new THREE.Clock();
var SCREEN_WIDTH = window.innerWidth, SCREEN_HEIGHT = window.innerHeight;

// custom global variables
var mirrorCube, mirrorCubeCamera; // for mirror material
var mirrorSphere, mirrorSphereCamera; // for mirror material
// start preloading
var images = new Array();
var imageObj = new Image();
images[0]="kaasschaafkleur.jpg";
images[1]="box1.jpg";
images[2]="box3.jpg";
images[3]="box2.jpg";
images[4]="box4.jpg";
images[5]="box5.jpg";
images[6]="box6.jpg";
for(var i = 0; i<= images.length; i++) {
  imageObj.src = images[i];
  console.log(images);
}
audioElement.load();
init();
animate();

setInterval(function(){audioElement.play()}, 10000);


// FUNCTIONS 		
function init() {
	part = 0;
	// SCENE
	var loadScene = createLoadScene();
	scene = loadScene.scene;
	camera = loadScene.camera;

	// RENDERER
	renderer = new THREE.WebGLRenderer( {antialias:true} );
	context = renderer.getContext();
	renderer.setSize(SCREEN_WIDTH, SCREEN_HEIGHT);
	container = document.createElement( 'div' );
	document.body.appendChild( container );
	container.appendChild( renderer.domElement );
	// EVENTS
	THREEx.WindowResize(renderer, camera);
	THREEx.FullScreen.bindKey({ charCode : 'm'.charCodeAt(0) });
	// CONTROLS
//	controls = new THREE.TrackballControls( camera );
	// STATS
	/*stats = new Stats();
	stats.domElement.style.position = 'absolute';
	stats.domElement.style.bottom = '0px';
	stats.domElement.style.zIndex = 100;
	container.appendChild( stats.domElement );*/
	canvas = document.createElement( 'canvas' );
	context = canvas.getContext( '2d' );
	
	container.appendChild(canvas); 
	canvas.width = SCREEN_WIDTH; 
	canvas.height = SCREEN_HEIGHT;
	var hue = [
	  [255,   0,   0 ], // 0, Red,       0Â°
	  [255, 255,   0 ], // 1, Yellow,   60Â°
	  [  0, 255,   0 ], // 2, Green,   120Â°
	  [  0, 255, 255 ], // 3, Cyan,    180Â°
	  [  0,   0, 255 ], // 4, Blue,    240Â°
	  [255,   0, 255 ], // 5, Magenta, 300Â°
	  [255,   0,   0]]; // 6, Red,     360Â°
	
	gradient = context.createLinearGradient(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
	for (var i = 0; i <= 6; i++) {
	  color = 'rgb(' + hue[i][0] + ', ' + hue[i][1] + ', ' + hue[i][2] + ')';
	  gradient.addColorStop(i * 1/6, color);
	}
	
}

function animate() 
{
    requestAnimationFrame( animate );
	render();		
	update();
}

function update()
{
	//controls.update();
	//stats.update();
}

function render() 
{
	var seconds		= Date.now() / 1000;
	var time = audioElement.currentTime; 
    	
	var txt = [];
	  
	if (time < 7) {
		txt[0] = 'deFEEST                                              Kansloos';
		txt[1] = '                       outline 2012';
	} else if (time < 27) {
		txt[0] = 'Geetings to :';
		txt[1] = '';
		txt[2] = 'Everybody stupid enough to watch this demo.';
	}
	
	/*
	 
People who have put up with uss during outline 2012.
The vitamines, for keeping me alive.
Our dads for making the biggest mistake of their lives.

Stuff you did not want to know

A sleepingbag got moist during this party.
New dry humping record of 5 hours set.
Lying down with 2 bitches is okay.
Germans can mix wodka with insta lemonade, and create poison.
Swedes just go to the store to get poison.
No bronies jiffed during this party (as far as we know).
Only 2 people wanted to join in the all male bikini contest.
Lego can be used to prepare drinks.
Jinx is stressed out over stencil buffers.
The only none-fail in this demo is the graphics we bought.

Credits:

Defeest (the second generation)
Mimi
WebGL tutorials.
Ableton Live

Last but not least :

For more fail join us at X2012 and OHM2013

*/
	
	context.clearRect (0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
	context.globalCompositeOperation = 'source-over';
	// Big rainbow text
	context.fillStyle=gradient;
	context.font = 'bold 40px sans-serif';
	context.fillText('Kansloos @ '+(audioElement.currentTime), 10, 30);

	for(i = 0; i < txt.length; i++) {
	  context.fillText(txt[i], 10, 100+(50*i));	
	}
	
	if (time > .5 && time < 30) {
	  if (part == 0) {
	    var loadScene = createPlaneScene();
	    scene = loadScene.scene;
	    camera = loadScene.camera;
	    part = 1;
	  }
		mirrorCube.rotation.z += .01;
	}
	
	if (time > 40 && part == 1) {
	  var loadScene = createTunnelScene();
	  scene = loadScene.scene;
	  camera = loadScene.camera;
	  part = 2;
	}
	
	// move the CubeCamera to the position of the object
	//    that has a reflective surface, "take a picture" in each direction
	//    and apply it to the surface.
	// need to hide surface before and after so that it does not
	//    "get in the way" of the camera
	if (part == 1) {
		mirrorCube.visible = false;
		mirrorCubeCamera.updateCubeMap( renderer, scene );
		mirrorCube.visible = true;

		mirrorSphere.visible = false;
		mirrorSphereCamera.updateCubeMap( renderer, scene );
		mirrorSphere.visible = true;
	}
	// move the texture to give the illusion of moving thru the tunnel
	if (part == 2) {
		texture.offset.y	+= 0.008;
		texture.offset.y	%= 1;
		texture.needsUpdate	= true;
	}

	// move the camera back and forth
	var radius		= 0.70;
	var angle		= Math.sin(0.05 * seconds * Math.PI) / 4;
	camera.position.x	= offset.x + Math.cos(angle - Math.PI/2) * radius;
	camera.position.y	= offset.y + Math.sin(angle - Math.PI/2) * radius;
	camera.rotation.z	= offset.z + angle;

	renderer.render( scene, camera );
}


function createLoadScene() {

	var result = {

		scene:  new THREE.Scene(),
		camera: new THREE.PerspectiveCamera( 65, window.innerWidth / window.innerHeight, 1, 1000 )

	};

	result.camera.position.z = 100;
	result.scene.add( result.camera );

	var object, geometry, material, light, count = 500, range = 200;

	material = new THREE.MeshLambertMaterial( { color:0xffffff } );
	geometry = new THREE.CubeGeometry( 5, 5, 5 );

	for( var i = 0; i < count; i++ ) {

		object = new THREE.Mesh( geometry, material );

		object.position.x = ( Math.random() - 0.5 ) * range;
		object.position.y = ( Math.random() - 0.5 ) * range;
		object.position.z = ( Math.random() - 0.5 ) * range;

		object.rotation.x = Math.random() * 6;
		object.rotation.y = Math.random() * 6;
		object.rotation.z = Math.random() * 6;

		object.matrixAutoUpdate = false;
		object.updateMatrix();

		result.scene.add( object );

	}

	result.scene.matrixAutoUpdate = false;

	light = new THREE.PointLight( 0xffffff );
	result.scene.add( light );

	light = new THREE.DirectionalLight( 0x111111 );
	light.position.x = 1;
	result.scene.add( light );

	return result;

}

function createTunnelScene() {

	var result = {

		scene:  new THREE.Scene(),
		camera: new THREE.PerspectiveCamera( 65, window.innerWidth / window.innerHeight, 1, 1000 )

	};

	offset.x = 0;
	offset.y = 0;
	offset.z = 0;
	
	result.scene.add(result.camera);

	// lights
	var light	= new THREE.DirectionalLight( 0xff8000, 1.5 );
	light.position.set( 1, 1, 0 ).normalize();
	result.scene.add( light );

	var light	= new THREE.DirectionalLight( 0xff8000, 1.5 );
	light.position.set( -1, 1, 0 ).normalize();
	result.scene.add( light );

	var light	= new THREE.PointLight( 0x44FFAA, 15, 25 );
	light.position.set( 0, -3, 0 );
	result.scene.add( light );

	var light	= new THREE.PointLight( 0xff4400, 20, 30 );
	light.position.set( 3, 3, 0 );
	result.scene.add( light );
	
//	scene.fog	= new THREE.FogExp2( 0x000000, 0.15 );

	var geometry	= new THREE.CylinderGeometry( 50, 50, 30, 32, 1, true );
	texture = new THREE.ImageUtils.loadTexture( 'outline.png' );
	texture.wrapT	= THREE.RepeatWrapping;

	var material	= new THREE.MeshLambertMaterial({map : texture});
	var mesh	= new THREE.Mesh( geometry, material );
	mesh.rotation.x	= Math.PI/2;
	result.scene.add( mesh );

	mesh.flipSided	= true;

	//result.scene.fog = new THREE.FogExp2( 0x000000, 0.15 );
	
	return result;

}

function createPlaneScene() {

	var result = {

		scene:  new THREE.Scene(),
		camera: null

	};

	// CAMERA
	var SCREEN_WIDTH = window.innerWidth, SCREEN_HEIGHT = window.innerHeight;
	var VIEW_ANGLE = 45, ASPECT = SCREEN_WIDTH / SCREEN_HEIGHT, NEAR = 0.1, FAR = 20000;
	result.camera = new THREE.PerspectiveCamera( VIEW_ANGLE, ASPECT, NEAR, FAR);
	result.scene.add(result.camera);
	result.camera.position.set(10,150,200);
	offset.x = 10;
	offset.y = 150;
	offset.z = 200;
	result.camera.lookAt(scene.position);	

	// LIGHT
	var light = new THREE.PointLight(0xffffff);
	light.position.set(0,250,0);
	result.scene.add(light);
	// FLOOR
	var floorTexture = new THREE.ImageUtils.loadTexture( 'kaasschaafkleur.jpg' );
	//floorTexture.wrapS = floorTexture.wrapT = THREE.RepeatWrapping; 
	//floorTexture.repeat.set( 10, 10 );
	var floorMaterial = new THREE.MeshBasicMaterial( { map: floorTexture } );
	var floorGeometry = new THREE.PlaneGeometry(250, 350, 10, 10);
	var floor = new THREE.Mesh(floorGeometry, floorMaterial);
	floor.position.y = -0.5;
	floor.doubleSided = true;
	result.scene.add(floor);
	
	// SKYBOX/FOG
	var materialArray = [];
	materialArray.push(new THREE.MeshBasicMaterial( { map: THREE.ImageUtils.loadTexture( 'box1.jpg' ) }));
	materialArray.push(new THREE.MeshBasicMaterial( { map: THREE.ImageUtils.loadTexture( 'box3.jpg' ) }));
	materialArray.push(new THREE.MeshBasicMaterial( { map: THREE.ImageUtils.loadTexture( 'box5.jpg' ) }));
	materialArray.push(new THREE.MeshBasicMaterial( { map: THREE.ImageUtils.loadTexture( 'box6.jpg' ) }));
	materialArray.push(new THREE.MeshBasicMaterial( { map: THREE.ImageUtils.loadTexture( 'box2.jpg' ) }));
	materialArray.push(new THREE.MeshBasicMaterial( { map: THREE.ImageUtils.loadTexture( 'box4.jpg' ) }));
	var skyboxGeom = new THREE.CubeGeometry( 5000, 5000, 5000, 1, 1, 1, materialArray );
	var skybox = new THREE.Mesh( skyboxGeom, new THREE.MeshFaceMaterial() );
	skybox.flipSided = true;
	result.scene.add( skybox );	
	
	////////////
	// CUSTOM //
	////////////
	
	var cubeGeom = new THREE.CubeGeometry(100, 100, 100, 1, 1, 1);
	mirrorCubeCamera = new THREE.CubeCamera( 0.1, 5000, 512 );
	mirrorCubeCamera.renderTarget.minFilter = THREE.LinearMipMapLinearFilter;
	result.scene.add( mirrorCubeCamera );
	var mirrorCubeMaterial = new THREE.MeshBasicMaterial( { envMap: mirrorCubeCamera.renderTarget } );
	mirrorCube = new THREE.Mesh( cubeGeom, mirrorCubeMaterial );
	mirrorCube.position.set(-75,50,0);
	mirrorCubeCamera.position = mirrorCube.position;
	result.scene.add(mirrorCube);	
	
	var sphereGeom =  new THREE.SphereGeometry( 50, 32, 16 ); // radius, segmentsWidth, segmentsHeight
	mirrorSphereCamera = new THREE.CubeCamera( 0.1, 5000, 512 );
	mirrorCubeCamera.renderTarget.minFilter = THREE.LinearMipMapLinearFilter;
	result.scene.add( mirrorSphereCamera );
	var mirrorSphereMaterial = new THREE.MeshBasicMaterial( { envMap: mirrorSphereCamera.renderTarget } );
	mirrorSphere = new THREE.Mesh( sphereGeom, mirrorSphereMaterial );
	mirrorSphere.position.set(75,50,0);
	mirrorSphereCamera.position = mirrorSphere.position;
	result.scene.add(mirrorSphere);

	return result;

}

