// Vertex shader input structure
struct VS_INPUT
{
    float4 Position   : POSITION;
    
    // stream 1
    
    float4 row0   : TEXCOORD0;
    float4 row1   : TEXCOORD1;
    float4 row2   : TEXCOORD2;
    float4 row3   : TEXCOORD3;
    float4 color   : COLOR0;
    float4 misc   : COLOR1;
};


// Vertex shader output structure
struct VS_OUTPUT
{
    float4 Position   : POSITION;
    float2 Texture    : TEXCOORD0;

    float4 color   : COLOR0;
    float texNum	: TEXCOORD1;
};


// Global variables
//float4x4 WorldViewProj;
float4x4 matView;


// Name: Simple Vertex Shader
// Type: Vertex shader
// Desc: Vertex transformation and texture coord pass-through
//
VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;                      //create an output vertex

	Out.Position = In.Position;
	Out.Texture = float2(0.5,0.5);
	Out.color = float4(1.0,1.0,1.0,1.0);
	float4x4 mat = {In.row0,In.row1,In.row2,In.row3};

	Out.Texture.xy = In.Position == float4(1.0,-1.0,1.0,1.0);
	
	
	if(In.misc.r > 1.0)
	{
		In.Position.xyz = mul(In.Position.xyz, float3x3(cos(In.misc.b),-sin(In.misc.b),0,sin(In.misc.b),cos(In.misc.b),0, 0,0,1 ));
		
	}
	else {
		mat  =mul(mat, matView);
		}
	
    Out.Position = mul(In.Position, mat);  //apply vertex transformation
    
    Out.texNum = In.misc.g;
  

	//Out.Position *= 0.0001;   
    //Out.Position += In.Position;
    //Out.Position = mul(In.Position, mat) + Out.Position;

	Out.color = In.color;

	if(Out.Position.z < 1) Out.color.a = clamp(min(Out.color.a, Out.Position.z),0,1);

    return Out;                         //return output vertex
}