uniform sampler2D vertextex;
uniform float psize;
varying vec4 color;
varying float dist;
varying vec4 look;
uniform vec3 lpos;
varying float alphae;
uniform float bri, darken;


void main() {
  vec4 pier = texture2DLod(vertextex, gl_MultiTexCoord1.xy, 0.0);
  vec4 pos = vec4(pier.rgb, 1.0);
  float dd = length(gl_ModelViewMatrix*pos);
  float br = bri-max(pier.a*darken, 0.0);
  
  alphae=1.0-pier.a*0.75;
  color = vec4(br*0.9, br*1.0, br*1.1, 1.0)*gl_Color;
  look = normalize(gl_ModelViewMatrix*pos);
  dist=dd;
  gl_PointSize = clamp((1.0 + 16.0/dd)*psize, 1.0, 32.0);
  gl_TexCoord[0] = gl_MultiTexCoord0;
  gl_Position = gl_ModelViewProjectionMatrix*pos;
}

