/*

 Name      :  Animation
 Notes     :  rgb image framebased animation
 
 frame based animation returning image array
 */
package demoplatform;

public class Animation extends Demoplatform {

  int[][] images;
  int imageCount;
  int animationframe;

  // constructor
  public Animation(String imagePrefix, int count) {
    debug("Animation():: initialize");

    imageCount = count;
    images = new int[imageCount][];

    int forwardCount = 0;
    for (int i = 0 ; i < imageCount; i++) {
      String filename = imagePrefix + i + ".png";
      images[i] = getImageArray(filename);
    }

    debug("Animation():: end initialize");
  }

  void draw(int[] renderBuffer) {
  }

  public int[] display(int speed) {
    animationframe = (int)Math.abs((System.currentTimeMillis() >> speed) % imageCount);
    return images[animationframe];
  }

  public int[] display(int speed, int time) {
    frame = (int)Math.abs((System.currentTimeMillis() >> speed) % imageCount);
    return images[frame];
  }
}

