/*

 Name      :  Disolve
 Notes     :  burn transition
 
 */
package demoplatform;

import demoplatform.GL.Noise3;

public class Disolvemask extends Demoplatform {

  float[] croud;       
  boolean[] prevMask;  
  boolean[] curMask;
  boolean[] diff;      
  boolean[] noiseMask; 
  float t;             
  int[] croudMask;    
  int[][] img;       
  final int N_IMG = 1; 
  int imgIndex;
  int width;
  int height;
  int pixelIndexLength;

  // constructor
  public Disolvemask() {
    debug("Disolvemask():: initialize");

    imgIndex = 0;
    width = rw;
    height = rh;

    croud = new float[width * height];
    prevMask = new boolean[width * height];
    curMask = new boolean[width * height];
    diff = new boolean[width * height];
    noiseMask = new boolean[width * height];

    croudMask = new int[width * height]; //createImage(width, height, RGB);
    initData();
    debug("Disolve():: end initialize");
  }

  private void initData() {
    createCroud();
    createCroudMask();

    t = 0;
    for (int y = 0; y < height; y++) {
      for (int x = 0; x < width; x++) {
        int index = y * width + x;
        boolean isBackground = (croudMask[y * width + x] & 0xFF) < 0x80;
        if (isBackground) {
          croud[index] = 0xFF000000;
        }
        prevMask[index] = curMask[index] = croud[index] < t;
        if (Math.random() > 0.90) {
          noiseMask[index] = !isBackground;
        }
      }
    }
    imgIndex = ++imgIndex < N_IMG ? imgIndex : 0;
  }

  private void createCroudMask() {
    for (int y = 0; y < rh; y++) {
      for (int x = 0; x < rw; x++) {
        croudMask[y * rw + x] = 0xFFFFFFFF;
      }
    }
  }

  private void createCroud() {
    if (croud == null) {
      croud = new float[width * height];
    }

    float bias = 150.0f;
    float xbase = (float) Math.random() * 100;
    float ybase = (float) Math.random() * 100;

    float xnoise = 0.0f;
    float ynoise = 0.0f;
    float inc = 0.02f;

    Noise3 noise3 = new Noise3();


    bias = Math.min(bias, 0xFF);
    for (int y = 0; y < height; y++) {
      float curBias = y * bias / height;
      for (int x = 0; x < width; x++) {

        float _gray = (int) (noise3.noise3((xnoise + xbase), (ynoise + ybase), 0) * (0xFF - bias) + curBias);
        //      float _gray = (int) (Noise.noise((xnoise + xbase), (ynoise + ybase),0) * (0xFF - bias) + curBias);
        //      float _gray = (int) (noise(xnoise + xbase, ynoise + ybase,1150) * (0xFF - bias) + curBias);
        croud[y * width + x] = _gray;
        xnoise += inc;
      }
      xnoise = 0.0f;
      ynoise += inc;
    }
  }

  void draw(int[] renderBuffer, int[] renderBuffer2) {
    for (int y = 0; y < height; y++) {
      for (int x = 0; x < width; x++) {
        int index = y * width + x;
        curMask[index] = croud[index] < t;
        diff[index] = prevMask[index] != curMask[index];
        prevMask[index] = curMask[index];

        if (curMask[index]) {
          renderBuffer[index] = renderBuffer2[index];
        } 
        else {
          renderBuffer[index] = 0x00000000;  // 背景
        }

        if (diff[index]) {
          renderBuffer[index] = 0xFFFFFFFF;  // 破れた感じの描画
        }
      }
    }
    t += 4;
  }

  void drawSolid(int[] renderBuffer, int bgColor) {
    for (int y = 0; y < height; y++) {
      for (int x = 0; x < width; x++) {
        int index = y * width + x;
        curMask[index] = croud[index] < t;
        diff[index] = prevMask[index] != curMask[index];
        prevMask[index] = curMask[index];

        if (curMask[index]) {
          renderBuffer[index] = bgColor;
        } 
        else {
          //  renderBuffer[index] = 0x00000000;  // 背景
        }

        if (diff[index]) {
          renderBuffer[index] = 0xFFFFFFFF;  // 破れた感じの描画
        }
      }
    }
    t += 2;
  }
}

