
/*
#include "Setting.java"
#include "FPMethod.java"
 * */

package demoplatform.GL;

/**
GL util of the GL.
We suggest you read The OpenGL Programming Guide - The Redbook, Chapter 1, 2, 3, 4, 9.
http://www.opengl.org/documentation/red_book/
*/
public class GLU
{
	private final GL gl;

public static final int FP_1= 				(1 << 16);
public static final int FP_0 =				0;
public static final int FP_PI=				(411774>>1);
public static final int FP_MAX_VALUE=		2147483647;
public static final int FP_MIN_VALUE=		-2147483647;


public int FPMUL(int x, int y) { 	return	MathFP.mul(x,y);}
public int FPDIV(int x,int y){ return 		MathFP.div(x,y);}
public int FPSIN(int s)		{ return	MathFP.sin(s);}
public int FPCOS(int s)		{ return	MathFP.cos(s);}
public int FPTAN(int s)		{ return	MathFP.tan(s);}
public int TOFP(int i) 		{ return	((i) << 16);}
public int TOINT(int i) 	{ return		((i) >> 16);}
//public int TOSTR(int i)		{ return	MathFP.toString(i);}
public int FPSQRT(int x)	{ return		MathFP.sqrt (x);}


	/**
	Basic constructor for GLU.
	*/
	public GLU(GL gl)
	{
		this.gl=gl;
	}
	
	/**
	gluPerspective specifies a viewing frustum into the world coordinate system.
	*/
	public void gluPerspective (int fovy, int aspect, int zNear, int zFar) 
	{
		// sout("uPerspective fovy: "+GETSTR(fovy));
		// sout("uPerspective aspect: "+GETSTR(aspect));
		// sout("uPerspective zNear: "+GETSTR(zNear));
		// sout("uPerspective zFar: "+GETSTR(zFar));
		int xmin, xmax, ymin, ymax;
		// sout ("uPerspective FPMUL(fovy , FPDIV(FP_PI ,  TOFP(360))): "+GETSTR(FPMUL(fovy , FPDIV(FP_PI ,  TOFP(360)))));
		ymax = FPMUL(zNear , FPTAN(FPMUL(fovy , FPDIV(FP_PI ,  TOFP(360))) ));
		ymin = -ymax;
		
		xmin = FPMUL(ymin , aspect);
		xmax =  FPMUL(ymax ,aspect);
		
		// sout("uPerspective ymax: "+GETSTR(ymax));
		// sout("uPerspective ymin: "+GETSTR(ymin));
		// sout("uPerspective xmax: "+GETSTR(xmax));
		// sout("uPerspective xmin: "+GETSTR(xmin));
		
		gl.glFrustum(xmin, xmax, ymin,ymax, zNear, zFar);
		
		//printMatrix(INDEX_PROJECTION);
	}
}