package demoplatform;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;

public final class ImageLoader implements Runnable {

  private Container container;
  private boolean rgba = false;
  private Thread thread;
  private Image image;
  private Object pixels;
  private boolean ready = false;

  ImageLoader(String s, Container container) {
    this(s, false, container);
  }

  ImageLoader(String s, boolean rgba, Container container) {
    this.image = null;
    this.pixels = null;
    this.container = container;
    this.ready = false;
    this.image = container.getToolkit().getImage(getClass().getResource(s));
    this.rgba = rgba;


    //run();
  }

  public void load() {
    start();
  }

  public boolean ready() {
    return ready;
  }

  public Object getPixels() {
    return pixels;
  }

  public void start() {
    thread = new Thread(this);
    thread.start();
  }

  public void run() {
    ImageObserver dummy = new ImageObserver() {

      public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
      }
    };

    MediaTracker mediaTracker = new MediaTracker(this.container);
    mediaTracker.addImage(image, 0);
    try {
      mediaTracker.waitForID(0);
    } 
    catch (InterruptedException ex) {
    }
    mediaTracker.removeImage(image);
    PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, image.getWidth(dummy), image.getHeight(dummy), rgba);

    try {
      pixelgrabber.grabPixels();
    } 
    catch (InterruptedException ex) {
    }
    pixels = pixelgrabber.getPixels();
    image.flush();
    ready = true;
  }
}

