/*

Name      :  Julia
Notes     :  A rotating and zooming bitmap.

2D rotozoomers are a combination of rotation and scaling transformations
Could possibly be the starting point for polygon texturing routines
utilized in 3D renderers.  One of the most famous rotozoomers is the one 
from Second Reality / Future Crew which this is based on.

references:
http://www.student.nada.kth.se/~d94-rol/fractals/javaapps.html

 */
package demoplatform;

public class Julia extends Demoplatform {

    int sin_LUT[];
    int sqr_LUT[];
    int l42;
    int j5;
    int l5;
    int[] texture;
    int[] palette;

    // constructor
    public Julia(int ww, int hh) {
        debug("Julia():: initialize");

        texture = new int[ww * hh];
        w = ww;
        h = hh;
        rw = w / 2;
        rh = h / 2;
        l42 = w * h - 1;
        j5 = 4 * -(w >> 1) + w + rw;
        l5 = 4 * -(h >> 1) + h + rh;

        sqr_LUT = new int[2048];
        sin_LUT = new int[2048];
        for (int i = 0; i < 2048; i++) {
            sqr_LUT[i] = (i * i) / 256; // multiply lookup table
            sin_LUT[i] = (int) (Math.sin(((i * Math.PI) / 512.0)) * 256);   // sin lookup table
        }

        // generate color palette in RGB.
        palette = new int[32];
        for (byte i = 0; i < 32; i++) {
            palette[i] = color(0, (int) (Math.atan(i * .2) * 128) & 255, (int) (Math.atan(i * .2) * 128) & 255, 255);      // Black to red
        }

        debug("Julia():: end initialize");
    }

    void draw(int currentTime) {
        int j = currentTime;
        int j10 = sin_LUT[j >> 3 & 0x3ff];
        int k10 = sin_LUT[j >> 2 & 0x3ff];
        int k4 = 0;
        int l4 = l42;

        for (int y = l5; y < 0; y++) {
            for (int x = j5; x < rw; x++) {
                int k9 = x << 2; // left shift when going smaller
                int l9 = y << 2;
                int i = 0;
                for (; i < 31; i++) {
                    int k9Sq = sqr_LUT[(k9 < 0) ? -k9 : k9]; // faster than Math.abs(k9)
                    int l9Sq = sqr_LUT[(l9 < 0) ? -l9 : l9]; // faster than Math.abs(l9)

                    if (k9Sq + l9Sq > 1024) {
                        break;
                    }

                    int i9 = k9;
                    int j9 = l9;
                    k9 = (k9Sq - l9Sq) + j10;
                    l9 = ((i9 * j9) >> 7) + k10;
                }
                int fractalPixel = palette[i];

                texture[k4++] = fractalPixel; //top half
                texture[l4--] = fractalPixel; //bottom half
            }
        }
    }
}

