/*

Name      :  Metaball
Notes     :  organic-looking n-dimensional objects.

The technique for rendering metaballs was invented by Jim Blinn in the early 1980s.
Computationally expensive because every pixel is multiplied against all other pixels
times the number of metaballs in scene.
158,148,0

references:
http://www.benryves.com/tutorials/blobs/
 */
package demoplatform;

import demoplatform.GL.MathFP;

public class Metaball extends Demoplatform {

    int[] meta_palette;
    int numBlobs = 4;          // two blobby blobs
    int buffer = 30;
    int blob_px[] = {0, buffer, 100 - buffer, 90};   // where blobs will first show
    int blob_py[] = {0, buffer, 100 - buffer, 45};

    // Movement vector for each blob
    int blob_dx[] = {1, 1, 1, 1};
    int blob_dy[] = {1, -1, 1, 1};
    int LUT[][];
    int effectWidth;
    int effectHeight;

    // constructor
    public Metaball(int rw, int rh) {

        debug("Metaball():: initialize");

        int random1 = MathFP.clamp((int) (Math.random() * 100), 30, 70);
        int random2 = MathFP.clamp((int) (Math.random() * 100), 30, 70);

        blob_px[1] = random1;
        blob_py[1] = random2;

        effectWidth = rw;
        effectHeight = rh;

        LUT = new int[rw][rh];

        for (int y = 0; y < rh; y++) {
            for (int x = 0; x < rw; x++) {
                // Increase 10K number to make your blobs bigger
                int temp = 30000 / ((x * x) + (y * y) + 1);

                // this prevents center of metballs from junking up (overflowed colors)
                if (temp > 255) {
                    temp = 255;
                }
                LUT[x][y] = temp;
            }
        }
        // Metaball palette colors
        meta_palette = new int[256];

        // generate flame color palette in RGB. need 256 bytes available memory
        for (int i = 0; i < 256; i++) {
            // meta_palette[i] = color(0, i & 255, i, 255);      // Black to red
            meta_palette[i] = color(0, 0, 0, MathFP.clamp(i - 90, 0, 255));      // Black to red
        }

        for (int i = 0; i < 80; i++) {
            meta_palette[i] = color(255, 0, 0, 0);      // Black to red
        }

        debug("Metaball():: end initialize");
    }

    public void draw(int[] renderBuffer) {
        for (int i = 0; i < numBlobs; i++) {
//            blob_px[i] += blob_dx[i];
//            blob_py[i] += blob_dy[i];

            blob_px[0] += blob_dx[0];
            blob_py[0] = 48;

            blob_px[1] = 50;
            blob_py[1] += blob_dy[1];

            blob_px[2] = 50;
            blob_py[2] += blob_dy[2];

            blob_px[3] += blob_dx[3];
            blob_py[3] = 48;

            // bounce across screen
            if (blob_px[i] < buffer) {
                blob_dx[i] = 1;
            }
            if (blob_px[i] >= effectWidth - buffer) {
                blob_dx[i] = -1;
            }
            if (blob_py[i] < buffer) {
                blob_dy[i] = 1;
            }
            if (blob_py[i] > effectHeight - buffer) {
                blob_dy[i] = -1;
            }
        }

        int m = 0;
        int pixelIndex = 0;
        for (int y = 0; y < effectHeight; y++) {
            for (int x = 0; x < effectWidth; x++) {
                m = 1;
                // unroll this loop for speed. there are only 2-3 metaballs
                for (int i = 0; i < numBlobs; i++) {
                    m += LUT[Math.abs(blob_px[i] - x)][Math.abs(blob_py[i] - y)];
                }
                if (m > 255) {
                    m = 255; // this prevents center of metballs from junking up (overflowed colors)
                }
                renderBuffer[pixelIndex++] = meta_palette[m];
            }
        }
    }
}


