/*

 Name      :  Plasma
 Notes     :  Cycles of changing colours warped to give an illusion of liquid, organic movement.
 
 Precalculated plasma effect values stored in flash rom array.  Colors are the sum of sine
 functions and various formulas.
 
 */
package demoplatform;

public class Plasma extends Demoplatform {

  int pal[];
  int[] cls;
  int pixelIndexLength;

  int[] imgArray;

  // constructor
  public Plasma(int rw, int rh) {
    debug("Plasma():: initialize");

    imgArray = getImageArray("/images/cube.png");

    int arrlen = 256;
    pal = new int[arrlen];

    int rf = 4;
    int gf = 2;
    int bf = 1;
    int rd = 0;
    int gd = arrlen / gf;
    int bd = arrlen / bf;


    // plasma stuff
    //double s1,s2;
    for (int i = 0; i < arrlen; i++) {
      int r = cos256(arrlen / rf, i + rd);
      int g = cos256(arrlen / gf, i + gd);
      int b = cos256(arrlen / bf, i + bd);
      pal[i] = color(r, g, b, 255);
      //pal[i] = colorIndex(r, g, b);
    }

    cls = new int[rw * rh];
    for (int x = 0; x < rw; x++) {
      for (int y = 0; y < rh; y++) {
        cls[x + y * rw] = (int) ((127.5 + +(127.5 * Math.sin(x / 32.0))) + (127.5 + +(127.5 * Math.cos(y / 32.0))) + (127.5 + +(127.5 * Math.sin(Math.sqrt((x * x + y * y)) / 32.0)))) / 4;
      }
    }

    pixelIndexLength = rw * rh;

    debug("Plasma():: end initialize");
  }


  // helper: get cosinus sample normalized to 0..255
  private int cos256(final int amplitude, final int x) {
    return (int) (Math.cos(x * (Math.PI * 2) / amplitude) * 127 + 127);
  }

  void draw(int currentTime, int[] renderBuffer) {
    int m = currentTime >> 4;

    for (int pixelIndex = 0; pixelIndex < pixelIndexLength; pixelIndex++) {
      //            renderBuffer[pixelIndex] = pal[(cls[pixelIndex] + m) & 255];
      if (((imgArray[pixelIndex]>>24)&0xFF)==0)
        renderBuffer[pixelIndex] = color(43, 38, 36, 255);
      else
        renderBuffer[pixelIndex] = pal[(cls[pixelIndex] + m) & 255];
    }
  }
}

