/*

 Name: Spinning Rays
 
 it will make you dizzy.  nice retro effect.
 
 */
package demoplatform;

import java.awt.Color;
import java.awt.Graphics;

public final class Rays extends Demoplatform {

  int x, y;
  double r = 700; // radius
  double angle;
  double angle2;
  double theta;
  double speed = .007F; // amout to increase each redraw (in radians)
  int rayNum = 7; // number of rays
  int rayAngle = 20; // angle of each ray

  // constructor
  public Rays() {
    debug("Rays():: initialize");
    x = h / 2;
    y = h / 2;
    debug("Rays():: end initialize");
  }
  public static final double PI = 3.141592653589793;

  public double radian(double deg) {
    double rad = (deg * (PI / 180));
    return rad;
  }

  public void draw(Graphics g) {
    // clear the background with black
    g.setColor(new Color(240, 240, 240));
    g.fillRect(0, 0, w, h);


    for (int i = 0; i <= rayNum; i++) {
      angle = i * radian((double) (360 / (rayNum + 1))) + theta;
      angle2 = angle + radian(rayAngle);

      double x2 = x + r * Math.cos(angle);
      double y2 = y + r * Math.sin(angle);
      double x3 = x + r * Math.cos(angle2);
      double y3 = x + r * Math.sin(angle2);

      int offset = 200;
      int[] xPoints = {
        offset + (int) x, offset + (int) x2, offset + (int) x3
      };
      int[] yPoints = {
        (int) y, (int) y2, (int) y3
      };

      g.setColor(new Color(85, 98, 112));
      g.fillPolygon(xPoints, yPoints, 3);
    }
    theta += speed;
  }
}

