/*

 Name      :  DYPP Text Sine Scroller
 Notes     :  A rotating and zooming bitmap.
 
 DYPP (Different Y Pixel Position) : the scrollbuffer (the line of text)
 is broken apart at every pixel ("One Pixel"), and each strip is displayed
 in a different Y position following a sintab.
 
 DYCP is a sinus scroller Width-of-char pixels
 
 references:
 http://www.brianpostma.com/java.html
 http://www.kyzer.me.uk/code/java/
 http://www.devnull.dk/demos.html
 
 */
package demoplatform;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import org.dvb.ui.DVBBufferedImage;
import org.dvb.ui.FontFactory;

public class Sinescroller extends Demoplatform {
  Font font;
  FontMetrics fm;
  Graphics2D goff;
  DVBBufferedImage ii;
  String s;
  int scrollcount = 0;
  int scrollpos = 0;
  final int extrawidth = 64;
  final int extraheight = 50;
  int[] sinetable;
  int sinepos = 0;
  final int numsine = 128;

  //font stuff
  // additional space between characters
  public int charS = 0;

  // max clipping area
  public int screenW = w + extrawidth;
  public int screenH = h + extraheight;

  // flag: set to true to use the Graphics.drawString() method
  // this is just used as a fail-safe
  public boolean useDefault = false;

  // height of characters
  public int charH = 10;

  // lookup table for character widths
  public int[] charW = {
    // first 32 characters
    9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
    9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
    9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
    9, 9, 
    // space
    9, 
    // everything else XD
    3, 5, 8, 8, 7, 8, 3, 5, 5, 6, 
    7, 3, 7, 3, 9, 6, 4, 6, 6, 6, 
    6, 6, 6, 6, 6, 3, 3, 6, 6, 6, 
    6, 9, 6, 6, 6, 6, 6, 6, 6, 6, 
    3, 6, 6, 6, 9, 6, 6, 6, 6, 6, 
    6, 7, 6, 6, 9, 6, 6, 6, 5, 9, 
    5, 4, 6, 4, 6, 6, 6, 6, 6, 6, 
    6, 6, 3, 4, 6, 3, 9, 6, 6, 6, 
    6, 6, 6, 6, 6, 6, 9, 6, 6, 6, 
    5, 3, 5, 4, 
    // delete
    9
  };
  // the bitmap font image
  private Image imgFont;

  // rainbow spectrum
  Color spectrum[];

  // constructor
  public Sinescroller() {
    debug("Sinescroller():: initialize");

    try {
      FontFactory fontFactory = new FontFactory();
      font = fontFactory.createFont("VigilanceTTF", Font.PLAIN, 50);
    } 
    catch (Exception ex) {
      font = new Font(null, Font.BOLD, 50);
    }

    int i, ampl;

    s =
    /*
                "From Brookline to Brooklyn, from Boston to New York City: " +
     "Pants off, go make a demo about it. That's exactly what we did, so get on the floor " +
     "and obey to the disco ball. We are Blu, we are Ray, we are Java and we are first!" +
     "      " +
     "Welcome people at the party place to Revision 2012. Tristar and Red Sector Incorporated, " +
     "Luis, Desire, Battlecommand and Rabenauge present a double first release for your " +
     "interactive entertainment: " +
     "FUNKY FRESH, the first Blu Ray player demo, also shown first on a PS3 without any" +
     "hardware modification. Use your controller or remote control to alter effects while" +
     "playing." +
     "      " +*/
    "Bluray of Light Greetings shine on: " +
      "ACS - BLACKLIGHT - CROME - CHROMAG - CONMAN - CTRIX - DARKLITE - DOC D - DHS - DIVISION ZERO - DOUBLE TROUBLE - " +
      "DR CLAW - DUBMOOD - FERRIS - FREQUENCY - GLXBLT - IC - IQ - ITALIAN BAD BOYS - IRATA - IROKOS - JASON SCOTT- JESPER KYD - " +
      "JESTER - KRUE - MAKTONE - METOIKOS - NORTHERN DRAGONS - PANTALOON - PHOENIX - POPSY TEAM -  RAVE NETWORK OVERSCAN - " +
      "QUEBARIUM - REBB - RESPONSE - REZ - ROMEO KNIGHT - SAL ONE - SIGFLUP - SMASH - TEAM POKEME - TEIS - THE SOUND WAVERS  - " +
      "TIM - TRIXTER- WILLBE - XMEN";

    sinetable = new int[numsine];
    //ampl = (rh - extraheight) / 4;
    ampl = 61 / 7;

    for (i = 0; i < numsine; i++) {
      sinetable[i] = (int) (Math.sin(2 * 3.14159265 * i / numsine) * ampl + ampl);
    }

    spectrum = generateColors(128);

    debug("Sinescroller():: end initialize");
  }

  void draw() {
    ii = new DVBBufferedImage(rw + extrawidth, rh + extraheight);
    goff = (Graphics2D) ii.getGraphics();
    goff.setComposite(AlphaComposite.Src);

    goff.setFont(font);
    fm = goff.getFontMetrics();

    //imgFont = getImage("/images/bitmapfontsample.png");
  }

  public void paint(Graphics g) {
    goff.clearRect(0, 0, rw, rh);
    Scroll();
    Sine();
    g.drawImage(ii, 0, 0, w, h, 0, 0, rw, rh, null); // 960 x 540
  }

  public void drawChar(Graphics g, int cIndex, int x, int y, int w, int h) {
    // non printable characters don't need to be drawn
    if (cIndex < 33) {
      return;
    }

    // neither does the delete character
    if (cIndex > 126) {
      return;
    }

    // get the characters position
    int cx = cIndex * 8;

    // reset the clipping rectangle
    g.setClip(0, 0, screenW, screenH);

    // resize and reposition the clipping rectangle
    // to where the character must be drawn
    g.clipRect(x, y, w, h);

    // draw the character inside the clipping rectangle
    g.drawImage(imgFont, x - cx, y, null);
  }

  public void drawString(Graphics g, String sTxt, int x, int y) {
    // get the strings length
    int len = sTxt.length();

    // set the starting position
    int cx = x;

    // if nothing to draw return
    if (len == 0) {
      return;
    }

    // our fail-safe
    if (useDefault) {
      g.drawString(sTxt, x, y);

      return;
    }

    // loop through all the characters in the string
    for (int i = 0; i < len; i++) {

      // get current character
      char c = sTxt.charAt(i);

      // get ordinal value or ASCII equivalent
      int cIndex = (int) c;

      // lookup the width of the character
      int w = charW[cIndex];

      // draw the character
      drawChar(g, cIndex, cx, y, w, charH);

      // go to the next drawing position
      cx += (w + charS);
    }

    // reset the clipping rectangle
    g.setClip(0, 0, screenW, screenH);
  }

  public void Scroll() {
    String tmp;
    
    scrollcount -= 5;
    goff.copyArea(2, rh, rw - 2 + extrawidth, extraheight, -10, 0);

    if (scrollcount <= 0) {
      tmp = s.substring(scrollpos, scrollpos + 1);
      scrollpos = (scrollpos + 1) % s.length();

      /* bitmap font
       drawString(goff, tmp, rw, rh + 8 + (10));
       scrollcount = (tmp.length() * 9) / 2;
       */

      // vector font
      goff.setColor(new Color(0, 0, 0));
      goff.drawString(tmp, 2 + rw, 2 + rh + 8 + (fm.getHeight() / 2));

      goff.setColor(spectrum[scrollpos % 127]);
      //goff.setColor(new Color(128, 192, 255));
      goff.drawString(tmp, rw, rh + 8 + (fm.getHeight() / 2));

      scrollcount = fm.stringWidth(tmp) / 2;
    }
  }

  public void Sine() {
    int tmppos = sinepos;
    int i;
    sinepos = (sinepos + 1) % numsine;
    for (i = 0; i < rw / 3; i++) {
      tmppos--;
      if (tmppos < 0) {
        tmppos = numsine - 1;
      }
      goff.copyArea(i * 3, rh, 3, extraheight, 0, -extraheight - sinetable[tmppos]);
    }
  }

  public Color[] generateColors(int n) {
    Color[] cols = new Color[n];
    for (int i = 0; i < n; i++) {
      cols[i] = new Color(Color.HSBtoRGB((float) i / (float) n, 0.85f, 1.0f));
    }
    return cols;
  }
}

