/*

 Name: Star Field
 
 the stars are coming at you in 3D
 
 */
package demoplatform;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;

public final class Star extends Demoplatform {

  int SPEED = 4;

  public Random generator;

  int numstars = 125;
  int[] x = new int[numstars];
  int[] y = new int[numstars];
  int[] z = new int[numstars];
  int[] sx = new int[numstars];
  int[] sy = new int[numstars];

  // constructor
  public Star() {
    debug("Star():: initialize");
    generator = new Random();
    debug("Star():: end initialize");
  }

  private final int nextInt(int low, int high) {
    return low + generator.nextInt(Math.abs(high - low));
  }

  private final void SetPosition(int whichStar) {
    z[whichStar] = nextInt(100, 255);
    x[whichStar] = nextInt(-w, w);
    y[whichStar] = nextInt(-h, h);
  }

  public void draw(Graphics g) {

    // clear the background with black
    g.setColor(new Color(0, 0, 0));
    g.fillRect(0, 0, w, h);

    int starX;
    int starY;

    for (int whichStar = 0; whichStar < numstars; whichStar++) {

      // get array values
      starX = (x[whichStar] << 6) / (1 + z[whichStar]) + w/2;
      starY = (y[whichStar] << 6) / (4 + z[whichStar]) + h/2;

      if (z[whichStar] < SPEED) {
        SetPosition(whichStar);
      }
      z[whichStar] -= SPEED;

      if (starX <= 4 | starX > w - 4 | starY <= 4 | starY > h - 4) {
        z[whichStar] = 255;
        starX = 0;
        starY = 0;
      }

      int starColor = 255 - z[whichStar];
      g.setColor(new Color(starColor, starColor, starColor));
      g.fillRect(starX, starY, 2, 2);
    }
  }
}

