/*

 Name      :  Vectorballs
 Notes     :  2D circles spinning in 3D space
 
 A vector ball is a 2D Sprite represented in 3D space.
 Based on code by Peter Knight, Tinker.it.  
 
 references:
 http://code.google.com/p/tinkerit/
 
 */
package demoplatform;

import java.awt.Graphics;
import java.awt.Image;

public final class Vectorball extends Demoplatform {

  byte[] ballPosnX = {
    -2, -1, 0, 1, 2, -3, 3, 4, -4, -4, 4, -4, 4, -4, 4, -4, 4, -3, 3, -2, -1, 0, 1, 2
  };
  byte[] ballPosnY = {
    -4, -4, -4, -4, -4, -3, -3, -2, -2, -1, -1, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 4, 4
  };
  float angx = 0;
  float angy = 0;
  float angz = 0;
  int NUM_BALLS = 24;
  float[] ballX;
  float[] ballY;
  float[] ballZ;
  float jump = 0;
  int rw = w / 2;
  int rh = h / 2;
  Image[] texture;

  // constructor
  public Vectorball() {
    debug("Vectorball():: initialize");

    ballX = new float[NUM_BALLS];
    ballY = new float[NUM_BALLS];
    ballZ = new float[NUM_BALLS];

    texture = new Image[4];
    texture[0] = getImage("/images/vectorball64x64_0.png");
    texture[1] = getImage("/images/vectorball64x64_1.png");
    texture[2] = getImage("/images/vectorball64x64_2.png");
    texture[3] = getImage("/images/vectorball64x64_3.png");

    debug("Vectorball():: end initialize");
  }

  public void draw(Graphics g, boolean half) {
    float cosangx = (float) Math.cos(angx);
    float sinangx = (float) Math.sin(angx);
    float cosangy = (float) Math.cos(angy);
    float sinangy = (float) Math.sin(angy);
    float cosangz = (float) Math.cos(angz);
    float sinangz = (float) Math.sin(angz);

    for (int n = 0; n < NUM_BALLS; n++) {
      int x = ballPosnX[n];
      int y = ballPosnY[n];
      int z = 0;

      // Rotate about x axis
      float x2 = x;
      float y2 = y * cosangx - z * sinangx;
      float z2 = y * sinangx + z * cosangx;

      // Rotate about y axis
      float x3 = x2 * cosangy + z2 * sinangy;
      float y3 = y2;
      float z3 = -x2 * sinangy + z2 * cosangy;

      // Rotate about z axis
      float x4 = x3 * cosangz - y3 * sinangz;
      float y4 = x3 * sinangz + y3 * cosangz;
      float z4 = z3;

      ballX[n] = x4;
      ballY[n] = y4;
      ballZ[n] = z4;
    }

    // Depth sort
    int increment = NUM_BALLS / 4;  // same as: NUM_BALLS / 4

      while (increment > 0) {
      for (int i = increment; i < NUM_BALLS; i++) {
        int j = i;
        float tempX = ballX[i];
        float tempY = ballY[i];
        float tempZ = ballZ[i];
        while ( (j >= increment) && (ballZ[j - increment] > tempZ)) {
          ballX[j] = ballX[j - increment];
          ballY[j] = ballY[j - increment];
          ballZ[j] = ballZ[j - increment];
          j = j - increment;
        }
        ballX[j] = tempX;
        ballY[j] = tempY;
        ballZ[j] = tempZ;
      }
      increment = (increment == 2) ? 1 : (int) (increment / 2.2);
    }

    jump *= 0.7;
    if (jump <= 0.07F) {
      jump = 0;
    }

    // Rotate camera
    angx += .1;
    if (angx >= 360) {
      angx = 0;
    }
    angy += .03;
    if (angy >= 360) {
      angy = 0;
    }
    angz += .03;
    if (angz >= 360) {
      angz = 0;
    }
  }

  public void rotate(Graphics g, int ballx, int bally, boolean half) {

    // Render with perspective
    for (int i = 0; i < NUM_BALLS; i++) {
      float scale = (ballZ[i] + 24);  // increase to make bigger or smaller
      float x = ballX[i] * (2 + jump) * scale + rw;
      float y = ballY[i] * (2 + jump) * scale + rh;

      int darkness = 1;

      if (ballZ[i] < -0.5) {
        darkness = 2;
      }
      if (ballZ[i] < -1.5) {
        darkness = 3;
      }

      if (ballZ[i] > 0.5) {
        darkness = 1;
      }
      if (ballZ[i] > 1.5) {
        darkness = 0;
      }

      int size = (3 * (int) scale)-15;
      int locx = (int) (x * 1) - 35;
      int locy = (int) (y * 1) - 35;

      if (ballZ[i] < 0 & half == true) {
        g.drawImage(texture[darkness], locx, locy, size, size, null);
      } 
      else if (ballZ[i] > 0 & half == false) {
        g.drawImage(texture[darkness], locx, locy, size, size, null);
      }
    }
  }
}

