function AudioPlayer(selector) {
	var tmpelement = $(selector);
	if (tmpelement.length != 1) {
		console.log('Selector "' + selector + '" returned more than one element. ');
		return false;
	}
	
	this.audioelement = tmpelement[0];
	this.state = 'stopped';
	this.audioelement.controls = false;
	this.audioelement.addEventListener('durationchange', durationListener);
	this.audioelement.addEventListener('onprogress', progressListener);
	this.audioelement.addEventListener('ended', endListener);
	
	this.initialized = true;
	
	function durationListener() {
		console.log('duration is now: ' + this.duration);
	}
	
	function progressListener() {
		console.log('progressing?');
	}
	
	function endListener() {
		console.log('audio ended');
	}

	this.load = function(callback) {
		if (callback) {
			this.audioelement.addEventListener('durationchange', callback);
		}
		this.audioelement.load();
	}
	
	this.getTime = function() {
		if (this.initialized) {
			return this.audioelement.currentTime;
		}
	}
	
	this.showControls = function() {
		this.audioelement.controls = true;
	}

	this.hideControls = function() {
		this.audioelement.controls = false;
	}

	this.setEndCallback = function(callback) {
		if (this.initialized) {
			this.audioelement.addEventListener('ended',function(){
				endListener();
				callback();
			});
		}
	}
	
	this.getState = function() {
		return this.state;
	}
	
	this.play = function() {
		if (this.initialized && (this.state=='stopped' || this.state=='paused')) {
			this.audioelement.play();
			this.state='playing';
		}
	}
	
	this.pause = function() {
		if (this.initialized) {
			switch (this.state) {
				case 'paused':
	
				case 'stopped':
					this.audioelement.play();
					this.state='playing';
					break;
				
				case 'playing':
					this.audioelement.pause();
					this.state = 'paused';
					break;
				
				default:
					console.log('unknown audio state "' + this.state + '" , bailing out');
			}
		}
	}
	
	return true;
}



