function DemoEngine(selector) {
	this.partdata = [];
	this.assets = { urls: {} };
	this.renderers = {};
	this.rendertargets = {};

	var tmpelement = $(selector);
	if (tmpelement.length != 1) {
		console.log('Selector "' + selector + '" returned more than one element. ');
		return false;
	}
	this.element = tmpelement[0];
	
	if (this.element.clientWidth && this.element.clientWidth != 0) {
		this.width = this.element.clientWidth;
		this.height = Math.floor(this.element.clientWidth / (16/9));
	} else {
		this.width = 810;
		this.height = 456;
	}
	
	this.getAspectRatio = function() {
		return this.width/this.height;
	}
	
	this.getWidth = function() {
		return this.width;
	}
	
	this.getHeight = function() {
		return this.height;
	}
	
	this.statustextcontainer = null;
	
	this.setStatusTextContainer = function(container) {
		this.statustextcontainer = container[0];
	}

	this.addAsset = function(name, mimetype, asseturl) {
		if (this.assets[name]) {
			console.log('Warning! Overwriting asset: ' + name);
		}
		
		this.assets[name] = { 'mimetype': mimetype, 'url': asseturl, 'status': 'not_loaded' }

		this.assets.urls[asseturl] = name;
	}
	
	this.getLoadProgress = function() {
		var keys = Object.keys(this.assets);
		var total_assets = keys.length - 1;
		var loaded_assets = 0;

		for (var i=0; i<keys.length; i++) {
			if (this.assets[keys[i]] && (this.assets[keys[i]].status == 'loaded' || this.assets[keys[i]].status == 'cached')) {
				loaded_assets++;
			}
		}
		
		return loaded_assets/total_assets;
	}
	
	this.getAsset = function(key) {
		if (this.assets && this.assets[key]) {
			return this.assets[key];
		} else {
			console.log('['+key+'] not found in engine assets');
			return null;
		}
	}
	
	this.getAssetNameByURL = function(url) {
		return this.assets.urls[url];
	}
	
	this.loadAssets = function(donecallback, progresscallback, errorcallback) {
		console.log(this.assets);
		var done = true;

		for (var i=0; i<Object.keys(this.assets).length; i++) {
			var key = Object.keys(this.assets)[i];
		 	if (this.assets[key].status == 'not_loaded') {
		 		done = false;
		 		
		 		switch (this.assets[key].mimetype) {
		 			case 'image/jpg':
		 			case 'image/png':
		 					this.assets[key].obj = new Image();
		 				break;

		 			case 'audio/mp3':
		 			case 'audio/ogg':
		 					this.assets[key].obj = new Audio();
		 					this.assets[key].obj.autoplay = false;
		 					this.assets[key].obj.preload = 'auto';
		 					this.assets[key].obj.autobuffer = 'auto';
		 				break;
		 				
		 			case 'video/webm':
		 					this.assets[key].obj = document.createElement('video');
		 					this.assets[key].obj.width = 640;
		 					this.assets[key].obj.height = 360;
		 					this.assets[key].obj.autoplay = false;
		 					this.assets[key].obj.preload = 'auto';
		 					this.assets[key].obj.autobuffer = 'auto';
		 					
		 				break;

		 			case 'object3d':
		 			case 'texture':
		 					this.assets[key].obj = {};
		 				break;
		 			
		 			default:
		 				console.log('unknown mimetype for assetloader: ' + this.assets[key].mimetype);
		 				break;
		 		
		 		}

				this.assets[key].obj.id = key;
				this.assets[key].obj.dmsref = this;
		 		this.assets[key].status = 'loading';

				if (this.assets[key].mimetype == 'image/jpg' || this.assets[key].mimetype == 'image/png') {
					this.assets[key].obj.onload = function() {
						this.dmsref.assets[this.id].status = 'loaded';
						var progress = this.dmsref.getLoadProgress();
	
						if (progresscallback) {
							progresscallback(progress);
						}
	
						if (progress == 1) {
							donecallback();
						}
					}

			 		this.assets[key].obj.src = this.assets[key].url;
				} else if (this.assets[key].mimetype == 'texture') {
 					this.assets[key].obj.texture = THREE.ImageUtils.loadTexture(this.assets[key].url, THREE.UVMapping, function(ref) {
 						var refsrc = '';

 						if (ref && ref.attributes && ref.attributes.length == 2 && ref.attributes[1].value ) {
 							refsrc = ref.attributes[1].value;
 						}
 						
 						var assetname = global_engine.getAssetNameByURL(refsrc);
 						var asset = global_engine.assets[assetname];
 						
						asset.status = 'loaded';
	
						var progress = global_engine.assets[assetname].obj.dmsref.getLoadProgress();
						asset.obj.src = asset.url;
						
						if (progresscallback) {
							progresscallback(progress);
						}
						
						if (progress == 1) {
							donecallback();
						}
 					});
				}else if (this.assets[key].mimetype == 'object3d') {
					this.assets[key].loader = new THREE.OBJLoader();
					this.assets[key].loader.load(this.assets[key].url, function(ref) {
						
						var refsrc = ref.urlref;
						
						var assetname = global_engine.getAssetNameByURL(refsrc);
						var asset = global_engine.assets[assetname];
						asset.object3d = ref;
						
						asset.status = 'loaded';
						
						var progress = global_engine.assets[assetname].obj.dmsref.getLoadProgress();
						asset.obj.src = asset.url;
						
						if (progresscallback) {
							progresscallback(progress);
						}
						
						if (progress == 1) {
							donecallback();
						}
					});
				} else {
					$.ajax({
						url: this.assets[key].url,
						type: 'GET',
						success: function() {
							var assetname = global_engine.getAssetNameByURL(this.url);
							var asset = global_engine.assets[assetname];
							
							asset.status = 'cached';
							var progress = asset.obj.dmsref.getLoadProgress();
							asset.obj.src = asset.url;
							
							if (progresscallback) {
								progresscallback(progress);
							}
							
							if (progress == 1) {
								donecallback();
							}
						},
						error: function() {
							console.log('error loading audio/video');

							if (errorcallback) {
								errorcallback();
							}
						}
					});
				}

		 		this.assets[key].obj.onerror = function() {
		 			this.dmsref.assets[this.id].status = 'error';
		 			console.log('Failed to load: ' + this.dmsref.assets[this.id].url);

		 			if (errorcallback) {
			 			errorcallback();
			 		}
		 		}
		 	}
		}
	}

	this.addPart = function(data) {
		this.partdata[this.partdata.length] = data;
	}
	
	this.draw = function(tick) {
		var parttick = tick;
		var prevpartlengths = 0;
		for (var i=0; i<this.partdata.length; i++) {
			
			if (i>0) { 
				parttick -= this.partdata[i-1].data.partlength;
				prevpartlengths += this.partdata[i-1].data.partlength;
			}

			if (tick<this.partdata[i].data.partlength + prevpartlengths) {
				this.partdata[i].data.player(this.partdata[i], parttick, tick);
				break;
			}
		}
	}
	
	this.addRenderTarget = function(name, width, height) {
		this.rendertargets[name] = {};
		this.rendertargets[name].target = new THREE.WebGLRenderTarget( width, height, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBAFormat } );
		this.rendertargets[name].width = width;
		this.rendertargets[name].height = height;
		
		this.rendertargets[name].getAspectRatio = function(){
			return this.width/this.height;
		}
	}
	
	this.addRenderer = function(name, antialias, shadowmap, width, height) {
		this.renderers[name] = new THREE.WebGLRenderer( { antialias: antialias } );
		this.renderers[name].shadowMapEnabled = shadowmap;
		
		if (width && height) {
			this.renderers[name].setSize(width, height);
		} else {
			this.renderers[name].setSize(this.getWidth(), this.getHeight());
		}

		this.renderers[name].setClearColorHex(0x000000, 1.0);
		this.renderers[name].clear();
	}
	
	this.addRenderer('main', true, true);
	
/*
	this.renderer = new THREE.WebGLRenderer( { antialias: true } );
	this.renderer.shadowMapEnabled = true;
	this.renderer.setSize(this.getWidth(), this.getHeight());
	this.renderer.setClearColorHex(0x000000, 1.0);
	this.renderer.clear();
*/
	$(selector).append(this.renderers['main'].domElement);
	this.renderers['main'].domElement.display = 'block';
}
