var common_vertex_shader = (function() {
	return "void main()	{ gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 ); }"
}());

var melonlennu_bg_fragment_shader = (function(){
	return "\
		uniform vec2 resolution;\
		uniform float time;\
		void main(void) {\
			vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy;\
			float tmpx = mod( floor(p.x + sin(time*1.1) * 2.0), 2.0);\
			float tmpy = mod( floor(p.y + sin(time*2.0) * 2.0), 2.0);\
			vec3 c = vec3(255.0, 0.0, 0.0);\
			if (tmpx+tmpy < 2.0) {\
			   c = vec3(255.0, 255.0, 255.0);\
			}\
			if (tmpy < 1.0 && (tmpx < 1.0)) {\
			   c = vec3(255.0, 0.0, 0.0);\
			}\
			gl_FragColor = vec4( c, 1.0);\
		}";
}());

var greetings = (function() {
	return "\
		uniform vec2 resolution;\
		uniform float time;\
		uniform sampler2D texture0;\
\
		vec3 deform( in vec2 p )\
		{\
			vec2 uv;\
			vec2 q = vec2( sin(1.1*time+p.x),sin(1.2*time+p.y) );\
			float a = atan(q.y,q.x);\
			float r = sqrt(dot(q,q));\
			uv.x = sin(0.0+1.0*time)+p.x*sqrt(r*r+1.0);\
			uv.y = sin(0.6+1.1*time)+p.y*sqrt(r*r+1.0);\
			return texture2D(tex0,uv*.5).xyz;\
		}\
\
		void main(void)\
		{\
			gl_FragColor = vec4( vec3(1.0, 1.0, 1.0) ,1.0);\
		}";
}());


/*
		    vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy;\
		    vec2 s = p;\
			vec3 total = vec3(0.0);\
			vec2 d = (vec2(0.0,0.0)-p)/40.0;\
			float w = 1.0;\
			for( int i=0; i<40; i++ )\
			{\
				vec3 res = deform(s);\
				res = smoothstep(0.1,1.0,res*res);\
				total += w*res;\
				w *= .99;\
				s += d;\
			}\
			total /= 40.0;\
			float r = 1.5/(1.0+dot(p,p));\
			gl_FragColor = vec4( total*r,1.0);\
*/

var alku_raw = [0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x000000ff, 0xffffff00, 0x000000ff, 0xff000000, 0x00ffffff, 0xff000000, 0x00000000, 0x0000ffff, 0xffff0000, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0x0000ff00, 0xffff0000, 0xffffffff, 0x00000000, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0xffffff00, 0x00000000, 0x00000000, 0x00ffffff, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x0000ffff, 0x00000000, 0xffff0000, 0x000000ff, 0x00000000, 0xff000000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x0000ffff, 0x00ffff00, 0xffff0000, 0x000000ff, 0x00000000, 0xff000000, 0x0000ffff, 0x00ffff00, 0xffff0000, 0x000000ff, 0x00ffff00, 0xffff0000, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0x000000ff, 0xffffff00, 0x00000000, 0x00000000, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00000000, 0xff000000, 0x0000ffff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0x000000ff, 0x00ffff00, 0x00000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00000000, 0xff000000, 0x00ffffff, 0x00000000, 0xffff0000, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ffff00, 0xffff0000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ffff00, 0xff000000, 0x000000ff, 0x0000ffff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0x00ffff00, 0x00000000, 0x00000000, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00000000, 0xffff0000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x000000ff, 0xffffff00, 0x00000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0x00ffff00, 0xff000000, 0x00ffffff, 0x00000000, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffffff00, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffffff00, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00ff0000, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0x0000ff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x0000ffff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00ffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffff00, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0x00000000, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00000000, 0x00ffffff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffff00, 0xffffffff, 0x00000000, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffffff, 0x0000ffff, 0xff000000, 0x00ffffff, 0xff000000, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0x0000ff00, 0xffff0000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0x00ffffff, 0xff000000, 0x0000ffff, 0x00000000, 0xffff0000, 0x000000ff, 0x00000000, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ffff00, 0xffff0000, 0x000000ff, 0x00ffff00, 0xffff0000, 0x00000000, 0x0000ffff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ffff00, 0xffff0000, 0x000000ff, 0x00000000, 0xff000000, 0xffffffff, 0x0000ffff, 0xff000000, 0x000000ff, 0x00ffff00, 0xffffff00, 0x000000ff, 0x00ffff00, 0xffffff00, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0xffffffff, 0x00ffffff, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00000000, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0x000000ff, 0x00000000, 0xff000000, 0x0000ffff, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0x00ffffff, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ff0000, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0x000000ff, 0x00000000, 0xff000000, 0x00ffffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xffffff00, 0x000000ff, 0x00ffff00, 0xffffff00, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0xffffffff, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ffff00, 0xff000000, 0x000000ff, 0x0000ffff, 0xffff0000, 0xff000000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ffff00, 0xffff0000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0x00000000, 0xff000000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0x00ffffff, 0xff000000, 0x0000ffff, 0x00000000, 0xffff0000, 0x000000ff, 0x00ffff00, 0xff000000, 0x0000ffff, 0x00ff0000, 0xff000000, 0x00ffffff, 0x00000000, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffffff, 0x0000ffff, 0xff000000, 0x00ffffff, 0xff000000, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0x00ffff00, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffffff, 0x00000000, 0x000000ff, 0x00ffffff, 0xff000000, 0xffffffff, 0x0000ffff, 0xff000000, 0xffffffff, 0x000000ff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0xffffff00, 0x00000000, 0x00000000, 0x000000ff, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0xffffffff, 0x00000000, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x0000ffff, 0xffff0000, 0x00000000, 0xff000000, 0x000000ff, 0x0000ffff, 0xffffff00, 0x00000000, 0x0000ffff, 0x00ffff00, 0xff000000, 0x000000ff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x0000ffff, 0xffffffff, 0x00000000, 0xffffff00, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0x00ffffff, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x000000ff, 0x00000000, 0xffffffff, 0x00000000, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x0000ffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0x000000ff, 0x0000ffff, 0xffffff00, 0xff000000, 0x000000ff, 0x00ffff00, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0xffffff00, 0x00000000, 0xffffffff, 0x000000ff, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0xffffffff, 0x00000000, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00ffffff, 0xff000000, 0xffffffff, 0x0000ffff, 0xff000000, 0xffffffff, 0x000000ff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xffff0000, 0x00000000, 0x000000ff, 0xffffff00, 0x00ffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xffff0000, 0x00000000, 0x00000000, 0xffff0000, 0x000000ff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xffff0000, 0x00000000, 0x00000000, 0xffff0000, 0x000000ff, 0x0000ffff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x00000000, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x00000000, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x000000ff, 0x0000ffff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x000000ff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffff00ff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffff0000, 0x000000ff, 0x00000000, 0x0000ffff, 0x00ff0000, 0xffff0000, 0x000000ff, 0xffff0000, 0xffffffff, 0x00000000, 0xffff0000, 0x0000ffff, 0x00ff0000, 0xff000000, 0x000000ff, 0xffffff00, 0x0000ffff, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xff000000, 0x000000ff, 0x00000000, 0x0000ffff, 0x00000000, 0x00ff0000, 0x00000000, 0xff000000, 0x00ffffff, 0x00000000, 0xff000000, 0x0000ffff, 0x00000000, 0x00000000, 0x00000000, 0xffff0000, 0x000000ff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0x000000ff, 0x000000ff, 0x00000000, 0x0000ffff, 0x00000000, 0x00ffff00, 0xffff0000, 0xff000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0x00000000, 0x00000000, 0x00000000, 0xffff0000, 0x00000000, 0x0000ffff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0xffffffff, 0x0000ffff, 0xffff0000, 0x0000ffff, 0xff000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0x00ffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xff000000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0x00000000, 0x00000000, 0x00ffffff, 0x00000000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x000000ff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0x00000000, 0x00000000, 0x0000ffff, 0xff000000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0xffff0000, 0xffffffff, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0xffff0000, 0x00ffffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xff000000, 0x0000ffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x00ffffff, 0x00000000, 0xff000000, 0x0000ffff, 0x00000000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x000000ff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffff0000, 0x00ffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0xffffffff, 0x00000000, 0xffff0000, 0x00ffffff, 0xff000000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x0000ffff, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0x0000ff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0x0000ffff, 0x00000000, 0xffff0000, 0x000000ff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0x0000ffff, 0x00ffff00, 0xffff0000, 0x000000ff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0x000000ff, 0x00ffff00, 0xff000000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0x0000ffff, 0x00ffff00, 0xffff0000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0x0000ffff, 0x00000000, 0xffff0000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0x00ffffff, 0x00000000, 0xffff0000, 0x00000000, 0x000000ff, 0x00ffffff, 0x00000000, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffffff, 0x00000000, 0x000000ff, 0x00ffff00, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00000000, 0x00ffff00, 0x00000000, 0xffff0000, 0x00000000, 0x00000000, 0x000000ff, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0xffffff00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00ffff00, 0x00ff0000, 0x00000000, 0xffff0000, 0x00000000, 0xff000000, 0x000000ff, 0x0000ffff, 0xffffff00, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffff00, 0x00000000, 0x0000ffff, 0xffff0000, 0xffffffff, 0x000000ff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffff00, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0xffff0000, 0x000000ff, 0x00000000, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xffff0000, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0xffff0000, 0x00000000, 0x0000ff00, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffff00, 0x00000000, 0xffff0000, 0x00000000, 0xffffffff, 0x000000ff, 0x00000000, 0xffffff00, 0x00000000, 0x00000000, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0x00000000, 0xffffffff, 0x000000ff, 0xffff0000, 0x00000000, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffffff, 0x000000ff, 0x0000ff00, 0xffff0000, 0x00000000, 0x0000ffff, 0xffff0000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xff000000, 0xffffffff, 0x0000ffff, 0xff000000, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x0000ffff, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0xffffffff, 0x000000ff, 0x00000000, 0xffffffff, 0x00ffffff, 0x00000000, 0xffffffff, 0x000000ff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0xffffffff, 0x0000ffff, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x000000ff, 0xffffff00, 0x00000000, 0x000000ff, 0xffffff00, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0x00000000, 0x000000ff, 0xffffff00, 0xff000000, 0x00000000, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0x00000000, 0x000000ff, 0xffffff00, 0xffffff00, 0x00000000, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00ffffff, 0xff000000, 0xffffffff, 0x00000000, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0xffffffff, 0x00ffffff, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 0xffff0000, 0xffffffff, 0x00000000, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0xffffffff, 0x0000ffff, 0xffff0000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0x000000ff, 0xffffff00, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x000000ff, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x000000ff, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0xffffff00, 0x000000ff, 0x00000000, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000000, 0x00000000, 0xffffff00, 0x0000ffff, 0xff000000, 0xffffffff, 0xffffffff, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff];

