#include version.txt
#include screen.txt

uniform sampler2D tex;
uniform sampler2D tex2;
uniform float scroll;
uniform float intensity;
uniform float zangle;
uniform float speedlayer_alpha;
uniform float accelerate;

varying mat4 texmatrix;

void main()
{
  // Roterende texturelag

  mat4 RotationMatrix0 = mat4(cos(zangle), -sin(zangle), 0.0, 0.0,
                              sin(zangle),  cos(zangle), 0.0, 0.0,
                                      0.0,          0.0, 1.0, 0.0,
                                      0.0,          0.0, 0.0, 1.0);

	mat4 RotationMatrix1 = mat4(cos(-zangle * 0.75), -sin(-zangle * 0.75), 0.0, 0.0,
                              sin(-zangle * 0.75),  cos(-zangle * 0.75), 0.0, 0.0,
                                              0.0,                  0.0, 1.0, 0.0,
								                              0.0,                  0.0, 0.0, 1.0);

	mat4 RotationMatrix2 = mat4(cos(zangle * 0.5), -sin(zangle * 0.5), 0.0, 0.0,
                              sin(zangle * 0.5),  cos(zangle * 0.5), 0.0, 0.0,
                                            0.0,                0.0, 1.0, 0.0,
								                            0.0,                0.0, 0.0, 1.0);

	mat4 RotationMatrix3 = mat4(cos(-zangle * 0.25), -sin(-zangle * 0.25), 0.0, 0.0,
                              sin(-zangle * 0.25),  cos(-zangle * 0.25), 0.0, 0.0,
                                              0.0,                  0.0, 1.0, 0.0,
                                              0.0,                  0.0, 0.0, 1.0);
     
	mat4 translationMatrix = mat4(1.0, 0.0, 0.0, -0.5,
                                0.0, 1.0, 0.0, -0.5,
                                0.0, 0.0, 1.0,  0.0,
                                0.0, 0.0, 0.0,  1.0);

	mat4 tm0 = (texmatrix * translationMatrix) * RotationMatrix0;
	mat4 tm1 = (texmatrix * translationMatrix) * RotationMatrix1;
	mat4 tm2 = (texmatrix * translationMatrix) * RotationMatrix2;
	mat4 tm3 = (texmatrix * translationMatrix) * RotationMatrix3;

	float scale0 = mod(2.0 - scroll, 2.0);
	float scale1 = mod(2.0 - scroll + 0.5, 2.0);
	float scale2 = mod(2.0 - scroll + 1.0, 2.0);
	float scale3 = mod(2.0 - scroll + 1.5, 2.0);

	vec2 texcoord0 = (gl_TexCoord[0] * tm0).xy;
	vec2 texcoord1 = (gl_TexCoord[0] * tm1).xy;
	vec2 texcoord2 = (gl_TexCoord[0] * tm2).xy;
	vec2 texcoord3 = (gl_TexCoord[0] * tm3).xy;

	vec3 tcol0 = texture2D(tex2, vec2( 0.0,  0.0) + (texcoord0 * scale0)).rgb * (2.0 - scale0);
	vec3 tcol1 = texture2D(tex2, vec2(-0.2,  0.1) + (texcoord1 * scale1)).rgb * (2.0 - scale1);
	vec3 tcol2 = texture2D(tex2, vec2( 0.0, -0.4) + (texcoord2 * scale2)).rgb * (2.0 - scale2);
	vec3 tcol3 = texture2D(tex2, vec2( 0.5, -0.8) + (texcoord3 * scale3)).rgb * (2.0 - scale3);

	vec4 tcol_final = vec4(tcol0 + tcol1 + tcol2 + tcol3, 1.0) / 2.0;
  

  
  // Tunnellag
  
	float PI = 3.14159265358979323846264;

	float x = (gl_TexCoord[0].x - 0.5) * (16.0 / 9.0);
	float y = gl_TexCoord[0].y - 0.5;

  float distance = sqrt(pow(x, 2.0) + pow(y, 2.0));
	float angle = (1.0 + (atan(x, y) / PI)) / 2.0;

	x = (1.0 * 0.2) / distance;
	y = angle;

	vec4 col0 = texture2D(tex2, vec2(x + mod((scroll / 2.0) + accelerate, 1.0), y)) + vec4((1.0 - distance) * (intensity * 1.5));
	vec4 col1 = texture2D(tex, vec2((x * 2.0) + mod((scroll * 2.0) + accelerate, 1.0), y * 2.0)) + vec4((1.0 - distance) * intensity);
	vec4 col2 = texture2D(tex, vec2((x * 4.0) + mod((scroll * 4.0) + accelerate, 1.0), y * 4.0)) + vec4((1.0 - distance) * intensity);

	gl_FragColor = screen(mix(col0, col1 * col2, speedlayer_alpha), tcol_final);
}
