#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bump;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

in vec3 ec_pos;
in vec2 pos_zw;
in vec2 uv;

#include <deferred/tangentspace_include.frag>

void main()
{
	vec3 t, b, n;
	per_fragment_tangent_space_w_normal(ec_pos, uv, t, b, n);

	diffuse_specular.rgb = texture(diffuse, uv).rgb;
	diffuse_specular.a = texture(specular, uv).r;
	
	mat3 mr = mat3(t, b, n);
	normal_depth.xyz = normalize( mr * (texture(bump, uv).rgb*2.0 - vec3(1.0)) );
	normal_depth.w = pos_zw.x/pos_zw.y;
}
