#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bump;

in vec2 pos_zw;
in vec3 normal;
in vec3 ec_pos;
in vec2 uv;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

#include <deferred/tangentspace_include.frag>

void main()
{
	vec3 tangent, binormal;
	per_fragment_tangent_space(ec_pos, uv, tangent, binormal);
	
	vec3 baseNormal = normalize(normal);
	vec3 b = texture(bump, uv).xyz*2.0 - vec3(1.0);
	mat3 mr = mat3(tangent, binormal, baseNormal);
	vec3 n = normalize(mr*b);

	diffuse_specular.rgb = texture(diffuse, uv).rgb;
	diffuse_specular.a = texture(specular, uv).r;

	normal_depth.xyz = n;//mix(baseNormal, n, 0.125);
	normal_depth.w = pos_zw.x/pos_zw.y;
}
