#version 330 core

uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2 viewport;
uniform mat4 ProjectionMatrix;

in vec4 light_pos;
in vec3 color;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

#if 0
#include <shading_model/blinn_phong_model_include.frag>
#endif

#include <shading_model/strauss_model_include.frag>

void main()
{
	vec2 uv = gl_FragCoord.xy * viewport;
	vec4 ds = texture(diffuse_specular, uv);
	vec4 nd = texture(normal_depth, uv);

	vec3 pos = calc_position(uv, nd.w);

	vec3 ld = light_pos.xyz - pos;
	float len = length(ld);
	if ( len > light_pos.w ) discard;

	vec2 screenDir = normalize(vec3(ProjectionMatrix * vec4(ld, 1.0))).xy * viewport;

	ld = normalize(ld);
	vec3 n = normalize(nd.xyz);
	vec3 ed = normalize(-pos);

	float atten = 1.0 - pow(len / light_pos.w, 2.0);

	//vec3 terms = calculate_blinn_phong_model(n, ld, ed, 32.0) * atten;
	vec3 terms = calculate_strauss_model(n, ld, ed, 0.1, 0.9, 0.0) * atten;

	frag_color.rgb = color*ds.rgb*terms.x + color*ds.a*(terms.y + terms.z);
	frag_color.a = terms.x;
}
