#version 330 core

uniform mat4 ProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform float time;

in float radius[1];

out vec2 uv;
out vec3 ec_pos;
out float intensity;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;


#define EMIT_VERTEX(VTX, UV) \
	intensity = alpha; \
	uv = UV; \
	ec_pos = VTX; \
	gl_Position = ProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	float blink = abs(sin(gl_in[0].gl_Position.x + time*4.0));
	vec4 pos = ModelViewMatrix * gl_in[0].gl_Position;
	float dist = dot(vec3(0.0, 0.0, -1.0), pos.xyz ) - 1.0;
	float alpha = smoothstep(0.0, 1.0, dist)*blink;
	if ( alpha <= 0.0 ) return;

	const vec3 XAxis = vec3(1.0, 0.0, 0.0);
	const vec3 YAxis = vec3(0.0, 1.0, 0.0);

	vec3 a = pos.xyz + (XAxis + YAxis)*radius[0];
	vec3 b = pos.xyz + (YAxis - XAxis)*radius[0];
	vec3 c = pos.xyz + (-XAxis - YAxis)*radius[0];
	vec3 d = pos.xyz + (XAxis - YAxis)*radius[0];

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
