#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;

// max 32 skinning matrices
uniform mat4 boneMatrix[32];

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;
layout (location = 5) in vec4 BONE_INDEX;
layout (location = 6) in vec4 BONE_WEIGHT;

out vec2 pos_zw;
out vec3 normal;
out vec2 uv;

void main()
{
	ivec4 matrixIndex = ivec4(BONE_INDEX);
	vec4 pos = vec4(0.0);
	vec3 norm = vec3(0.0);
	for (int i=0; i < 4; i++)
	{
		pos  += boneMatrix[ matrixIndex[i] ] * vec4(POSITION, 1.0) * BONE_WEIGHT[i];
		norm += mat3(boneMatrix[ matrixIndex[i] ]) * NORMAL * BONE_WEIGHT[i];
	}
	pos.w = 1.0;

	uv = TEXCOORD;
	normal = NormalMatrix * normalize(norm);
	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
