#version 330 core

uniform sampler2D decal;
uniform float alpha;

in vec2 uv;
in vec3 normal;

layout (location = 0) out vec4 diffuse_specular;

void main()
{
	vec4 color = texture(decal, uv);
	if ( alpha > color.a && color.r > 0.1 ) discard;
	diffuse_specular.rgb = vec3(1.0) - color.rgb;
	diffuse_specular.a = 1.0;
}

