#version 330 core

uniform mat4 TextureMatrix;
uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform samplerCube cubemap;

uniform vec2 viewport;

in vec4 light_pos; //x,y,z,size

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

#if 1
#include <shading_model/blinn_phong_model_include.frag>
#else
#include <shading_model/strauss_model_include.frag>
#endif


void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture(diffuse_specular, uv_pos);
	vec4 nd = texture(normal_depth, uv_pos);

	vec3 pos = calc_position(uv_pos, nd.w);

	vec3 ld = light_pos.xyz - pos;
	float len = min(length(ld), light_pos.w);
	//if ( len > light_pos.w ) discard;

	ld = normalize(ld);

	vec3 n = normalize(nd.xyz);
	vec3 ed = normalize(-pos);

	vec3 cn = normalize( vec3(TextureMatrix * vec4(pos, 1.0)) );
	cn.y = -cn.y;
	vec3 color = textureLod(cubemap, cn, 0.0).rgb;

	float atten = 1.0 - pow(len / light_pos.w, 2.0);
	vec3 terms = calculate_blinn_phong_model(n, ld, ed, 8.0) * atten;
	//vec3 terms = calculate_strauss_model(n, ld, ed, 0.1, 0.9, 0.0) * atten;

	frag_color.rgb = color*ds.rgb*terms.x + color*ds.a*terms.y;
	frag_color.a = terms.x;
}
