#version 330 core

uniform sampler2D diffuse;

in vec2 pos_zw;
in vec3 normal;
in vec2 uv;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

void main()
{
	vec4 diff = texture(diffuse, uv);
	if ( diff.a < 0.5 ) discard;

	diffuse_specular.rgb = diff.rgb;
	diffuse_specular.a = 0.0;

	normal_depth.xyz = normalize(normal * (gl_FrontFacing ? 1.0 : -1.0) );
	normal_depth.w = pos_zw.x/pos_zw.y;
}
