#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bump;

in vec2 pos_zw;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

void main()
{
	vec4 color = texture(diffuse, gl_PointCoord);
	if ( color.a < 0.1 ) discard;

	diffuse_specular.rgb = vec3(1.0); //color.aaa;
	diffuse_specular.a = texture(specular, gl_PointCoord).r;

	vec3 n = texture(bump, gl_PointCoord).xyz*2.0 - vec3(1.0);
	normal_depth.xyz = normalize(n);
	normal_depth.w = pos_zw.x/pos_zw.y;
}
