#version 330

in vec3 vNormal;
in vec3 vEye;
in vec2 TexCoord;

out vec4 out_Color;

uniform vec3 LightPos;

uniform samplerCube TexSampler;
uniform vec3 DiffuseColor; 
uniform float Reflectivity;

void main()
{
	
	vec3 n = normalize( vNormal );
	vec3 v = normalize( -vEye );
	vec3 l = normalize( LightPos - vEye );
	vec3 h = normalize( v + l );
	vec3 r = reflect( normalize( vEye ), n );
	
	float specularCoefficient = 60.0;

	vec3 cAmb = vec3( 0.0, 0.0, 0.0 );
	vec3 cDiff = DiffuseColor;
	vec4 ref = texture( TexSampler, r );
	vec3 cSpec = vec3( 1.0, 1.0, 1.0 );
	float diff = max( 0.0, dot( n, l ) );
	float spec = max( pow( ( dot( n, h ) ), specularCoefficient ), 0.0 ) * 0.0;
	
	out_Color = vec4( mix( ( cAmb + cDiff*diff + cSpec*spec ), vec3( ref ), Reflectivity ), 1.0 );
}