#version 330

in vec2 TexCoord;
out vec4 out_Color;

uniform sampler2D TexSampler;
uniform float CurrentTime;

void main()
{
	vec2 finalCoord = TexCoord;
	finalCoord.y = 1.0 - finalCoord.y;
	vec4 color = texture2D( TexSampler, finalCoord );
	if( color.a < 0.5 )
	{
		discard;
	}
	out_Color = color * 4.0;
}