#version 330

layout( location = 0 ) in vec3 InVertex;
layout( location = 1 ) in float InParticleSize;

out float ParticleSize;

uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform float CurrentTime;
uniform float Wave;

void main()
{
	ParticleSize = InParticleSize;
	vec3 pos = InVertex;
	if( Wave == 1.0f )
	{
		pos.y = pos.y * sin( ( CurrentTime / 4.0 ) + gl_VertexID );
	}
	gl_Position = ProjectionMatrix * ViewMatrix * vec4( pos, 1.0 );
}