#version 330

layout( location = 0 ) in vec3 InVertex;
layout( location = 1 ) in float InParticleSize;

out float ParticleSize;

uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform float CurrentTime;
uniform float Project;


void main()
{
	ParticleSize = InParticleSize;
	//vec3 dir = pos - vec3( 0.0, 0.0, 0.0 );
	//vec4 finalPos = vec4( pos + ( dir * (sin( 3.0f / 64.0 ) + 1.5f )/4.0f ), 1.0 );
	if( Project > 0.0 )
	{
		gl_Position = ProjectionMatrix * ViewMatrix * vec4( InVertex, 1.0 );
	}
	else
	{
		gl_Position = vec4( InVertex, 1.0 );
	}
}