#version 330

in vec3 vNormal;
in vec3 vEye;
in vec2 TexCoord;

out vec4 out_Color;

uniform vec3 LightPos;
uniform samplerCube TexSampler;

void main()
{
	
	vec3 n = normalize( vNormal );
	vec3 v = normalize( -vEye );
	vec3 l = normalize( LightPos - vEye );
	vec3 h = normalize( v + l );
	vec3 r = reflect( normalize( vEye ), n );
	
	float specularCoefficient = 60.0;

	vec4 ref = texture( TexSampler, r );

	vec3 cAmb = vec3( 0.0, 0.0, 0.0 );
	vec3 cDiff = vec3( 0.12, 0.242, 0.325 );
	vec3 cSpec = vec3( 0.8, 0.8, 0.8 );
	float diff = max( 0.0, dot( n, l ) );
	float spec = max( pow( ( dot( n, h ) ), specularCoefficient ), 0.0 );
	
	out_Color = vec4( mix( vec3( cAmb + cDiff*diff + cSpec*spec ), vec3( ref ), 0.5 ), 1.0 );
}