#version 150

in vec3 vNormal;
in vec3 vEye;
in vec2 TexCoord;

out vec4 out_Color;

uniform sampler2D TexSampler;

uniform vec3 LightPos;

uniform float CurrentTime;

void main()
{
	vec3 n = normalize( vNormal );
	vec3 l = normalize( LightPos - vEye );
	float diff = max( 0.0, dot( n, l ) );

	vec2 finalCoord = TexCoord;
	finalCoord.y = 1.0 - finalCoord.y;
	vec4 texColor = texture2D( TexSampler, finalCoord );

	out_Color = texColor*(vec4(diff)+vec4(.1f));
}