#version 130

in vec4 color;
in vec2 tex;

uniform sampler2D colormap; 
uniform float musictime;

void main(void) { 

  gl_FragColor = texture(colormap,tex);
  
  float average = (gl_FragColor.r + gl_FragColor.g + gl_FragColor.b) / 3.0;
  float diff = musictime - average;
  
  if (average < musictime/30.0) discard;
  else if (average < (musictime+5.0)/30.0) gl_FragColor *= vec4(diff,diff*0.2,diff*0.3,1.0)*gl_FragColor;
  
  
  
}