#version 330 core

layout(location = 0, index = 0) out vec4 outcol;

uniform sampler2DRect tex0;
uniform vec4 blurdir;

in vec2 texcoord0;

//triangle
// const float w0 = 16.0f / 46.0f;
// const float w1 = 8.0f / 46.0f;
// const float w2 = 4.0f / 46.0f;
// const float w3 = 2.0f / 46.0f;
// const float w4 = 1.0f / 46.0f;

//gauss
const float w0 = 70.0f / 256.0f;
const float w1 = 56.0f / 256.0f;
const float w2 = 28.0f / 256.0f;
const float w3 = 8.0f  / 256.0f;
const float w4 = 1.0f  / 256.0f;

//step
// const float w0 = 1.0f / 9.0f;
// const float w1 = 1.0f / 9.0f;
// const float w2 = 1.0f / 9.0f;
// const float w3 = 1.0f / 9.0f;
// const float w4 = 1.0f / 9.0f;

//TODO: assumes unnormalized coords (texrect)
//TODO: use bilin filtering
const float ofs0 = 0.0f;
const float ofs1 = 1.0f;
const float ofs2 = 2.0f;
const float ofs3 = 3.0f;
const float ofs4 = 4.0f;

//TODO: tex-gather
void main()
{
	vec4 colsum = vec4( 0.0f );
	colsum += w4 * texture( tex0, texcoord0 - ofs4 * blurdir.xy );
	colsum += w3 * texture( tex0, texcoord0 - ofs3 * blurdir.xy );
	colsum += w2 * texture( tex0, texcoord0 - ofs2 * blurdir.xy );
	colsum += w1 * texture( tex0, texcoord0 - ofs1 * blurdir.xy );
	colsum += w0 * texture( tex0, texcoord0 );
	colsum += w1 * texture( tex0, texcoord0 + ofs1 * blurdir.xy );
	colsum += w2 * texture( tex0, texcoord0 + ofs2 * blurdir.xy );
	colsum += w3 * texture( tex0, texcoord0 + ofs3 * blurdir.xy );
	colsum += w4 * texture( tex0, texcoord0 + ofs4 * blurdir.xy );

	outcol = colsum;
}
