#version 330 core

layout(location = 0, index = 0) out vec4 out_color0;

uniform vec4 diffcol;

in vec3 ws_norm;
in vec3 ws_lightvec;
in float ctrdist;

void main()
{
	float n_dot_l = dot( normalize(ws_norm), normalize(ws_lightvec) );

	const float wrap = 0.25f;
	float wrap_n_dot_l = n_dot_l * wrap + (1.0f-wrap);

	float ao = ctrdist*ctrdist;
	wrap_n_dot_l *= ao*ao;
	out_color0 = vec4( diffcol.rgb * vec3(wrap_n_dot_l), diffcol.a );
}
