#version 330 core

layout(location = 0, index = 0) out vec4 outcol0;

uniform vec4 time_s;

in vec3 ws_norm;
in vec3 ws_eyevec;
in vec3 v2f_os_pos;
in vec2 texcoord0;


float sat( float a ) {
	return clamp( a, 0.0f, 1.0f );
}

vec3 sph_light( vec3 in_ws_norm ) {
	const float C1 = 0.429043f;
	const float C2 = 0.511664f;
	const float C3 = 0.743125f;
	const float C4 = 0.886227f;
	const float C5 = 0.247708f;

	// Constants for Old Town Square lighting
	const vec3 L00  = vec3( 0.871297f,  0.875222f,  0.864470f);
	const vec3 L1m1 = vec3( 0.175058f,  0.245335f,  0.312891f);
	const vec3 L10  = vec3( 0.034675f,  0.036107f,  0.037362f);
	const vec3 L11  = vec3(-0.004629f, -0.029448f, -0.048028f);
	const vec3 L2m2 = vec3(-0.120535f, -0.121160f, -0.117507f);
	const vec3 L2m1 = vec3( 0.003242f,  0.003624f,  0.007511f);
	const vec3 L20  = vec3(-0.028667f, -0.024926f, -0.020998f);
	const vec3 L21  = vec3(-0.077539f, -0.086325f, -0.091591f);
	const vec3 L22  = vec3(-0.161784f, -0.191783f, -0.219152f);

	vec3 DiffuseColor;
	DiffuseColor =  C1 * L22 * (in_ws_norm.x * in_ws_norm.x - in_ws_norm.y * in_ws_norm.y) +
					C3 * L20 * in_ws_norm.z * in_ws_norm.z +
					C4 * L00 -
					C5 * L20 +
					2.0f * C1 * L2m2 * in_ws_norm.x * in_ws_norm.y +
					2.0f * C1 * L21  * in_ws_norm.x * in_ws_norm.z +
					2.0f * C1 * L2m1 * in_ws_norm.y * in_ws_norm.z +
					2.0f * C2 * L11  * in_ws_norm.x +
					2.0f * C2 * L1m1 * in_ws_norm.y +
					2.0f * C2 * L10  * in_ws_norm.z;

	//DiffuseColor *= ScaleFactor;

	return DiffuseColor;
}

//[0;1]
float rand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

float trunc( float x, float l )
{
	return floor(x*l)/l;
}

//remaps inteval [a;b] to [0;1]
float remap( float t, float a, float b ) {
	return sat( (t - a) / (b - a) );
}

void main()
{
	//float rnd0 = rand( time_s.xx );
	//rnd0 = remap( rnd0, 0.5, 1.0f );
	//float rnd = rand( vec2( trunc(v2f_os_pos.y, 0.25f + 0.5f * rnd0 ) ) );
	//float disc = remap( rnd, 0.8, 1.0f );
	//if ( disc > 0.04 )
	//	discard;
	//outcol0 = vec4( vec3( rnd ), 1 );
	//return;

	vec3 ws_refvec = reflect( ws_eyevec, ws_norm ); //TODO: halfvec?

	//float fresnel = max( 0.0f, acos(2*dot( ws_eyevec, ws_norm )) );
	float fresnel = 2.0f * pow( 1.0f - dot( ws_eyevec, ws_norm ), 5.0f );

	vec3 mat_diffcol = vec3( 0.225f );
	//vec3 mat_diffcol = 0.35f * vec3( 118, 151, 126 ) / 255.0f;
	//vec3 mat_diffcol = 0.65f * vec3( 76, 68, 87 ) / 255.0f;
	vec3 mat_speccol = vec3( 2.0f, 2.0f, 2.0f );

	//TODO: key light (with shadows ;) )

	vec3 amb_light = sph_light( ws_norm );
	vec3 spec_light = fresnel * sph_light( ws_refvec );

	vec3 lightcol = amb_light * mat_diffcol + spec_light * mat_speccol;

	lightcol *= texcoord0.yyy; //ahem... men det ser jo fint ud...

	outcol0 = vec4( lightcol, 1.0f );

	//DEBUG
	//outcol0 = vec4( texcoord0.y, 0.0f, 0.0f, 1.0f );
	//outcol0 = vec4( spec_light, 1.0f );
	//outcol0 = vec4( ws_refvec, 1.0f );
}
