#version 330 core

layout(location = 0, index = 0) out vec4 outcol;

uniform sampler2D tex0;

in vec2 texcoord0_nm;

float calcLuminance( vec3 rgbcol ) {
	return dot( vec3(0.299, 0.114, 0.587), rgbcol );
}

void main()
{
	vec3 sample_col = texture( tex0, texcoord0_nm ).rgb;
	float luminance = calcLuminance( sample_col );
	outcol = vec4( sample_col, luminance );
}
