#version 330 core

layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex;
uniform vec4 color;
uniform vec4 inverse_uv;
uniform vec4 time_s;
uniform mat4 modelmat;
uniform vec4 glitch;

in vec2 texcoord0;


float sat( float t ) {
	return clamp( t, 0.0f, 1.0f );
}

vec2 sat( vec2 t ) {
	return clamp( t, 0.0f, 1.0f );
}

//remaps inteval [a;b] to [0;1]
float remap  ( float t, float a, float b ) {
	return sat( (t - a) / (b - a) );
}

//note: /\ t=[0;0.5;1], y=[0;1;0]
float linterp( float t ) {
	return sat( 1 - abs( 2*t - 1 ) );
}

vec3 spectrum_offset( float t ) {
	vec3 ret;
	float lo = step(t,0.5f);
	float hi = 1.0f-lo;
	float w = linterp( remap( t, 1.0f/6.0f, 5.0f/6.0f ) );
	float neg_w = 1.0f-w;
	ret = vec3(lo,1.0f,hi) * vec3(neg_w, w, neg_w);
	return pow( ret, vec3(1.0f/2.2f) );
}

//note: [0;1]
float rand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

//note: [-1;1]
float srand( vec2 n ) {
	return rand(n) * 2 - 1;
}

float trunc( float x, float num_levels )
{
	return floor(x*num_levels) / num_levels;
}
vec2 trunc( vec2 x, float num_levels )
{
	return floor(x*num_levels) / num_levels;
}

void main()
{
	float time = time_s.x + modelmat[0].x + modelmat[0].z;

	float rnd0 = rand( trunc( vec2(time), 6.0f ) );
	float r0 = sat(0.7f + rnd0);
	float rnd1 = rand( vec2(trunc( texcoord0.x, 10*r0 ), time) ); //horz
	float r1 = 1-sat( 0.5f + rnd1 );
	float rnd2 = rand( vec2(trunc( texcoord0.y, 40*r1 ), time) ); //vert
	float r2 = sat( rnd2 );

	float rnd3 = rand( vec2(trunc( texcoord0.y, 10*r0 ), time) );
	float r3 = (1-sat(rnd3+0.8f)) - 0.1f;
	//outcol0 = vec4( vec3( r3 ), 1 );
	//return;

	vec2 uv = (inverse_uv.x>0) ? (1.0f-texcoord0.xy) : texcoord0;
	float ofs = 0.05f * r2 * glitch.x * ( rnd0 > 0.5 ? 1.0 : -1.0f );

	uv.x += 0.1 * r3 * glitch.x;

	vec4 sum = vec4(0.0f);
	vec3 wsum = vec3(0.0f);
	for( int i=0; i<10; ++i )
	{
		float t = float(i) / 10.0f;
		uv.y += ofs * t;
		vec4 samplecol = texture( tex, uv );
		vec3 s = spectrum_offset( t );
		samplecol.rgb = samplecol.rgb * s;
		sum += samplecol;
		wsum += s;
	}
	sum.rgb /= wsum;
	sum.a /= 10.0f;

	outcol0.a = sum.a * color.a;
	outcol0.rgb = (1.0f-sum.rgb) * color.rgb * outcol0.a;
}
