#version 330 core

layout(location = 0, index = 0) out vec4 out_color0;

uniform sampler2D bgdepth_tex;
uniform vec4 resolution;
uniform vec4 os_eyepos;
uniform vec4 cam_nearclip_plane_os;
uniform vec4 objscale; //note: scale-xyz, 0

in vec3 v2f_pos_os_nm;
//in vec3 v2f_pos_nearclip_os_nm;
in vec3 v2f_pos_os;


// ====
//note: ray_dir should be normalized
vec3 isect_RayPlane( vec3 ray_org, vec3 ray_dir, vec4 plane )
{
	vec3 n = plane.xyz;
	float d = plane.w;
	float t = -( dot(ray_org, n) + d ) / dot( ray_dir, n );
	return ray_org + t * ray_dir;
}


void main()
{
	vec2 fs_texcoord_nm = gl_FragCoord.xy * resolution.zw;
	float bg_depth_sample = texture( bgdepth_tex, fs_texcoord_nm ).r;
	bool zpass = gl_FragCoord.z < bg_depth_sample;

	if ( gl_FrontFacing )
	{
		out_color0 = zpass ? vec4( v2f_pos_os_nm, 1 ) : vec4(0);
	}
	else
	{
		//note: output point projected to nearclip-plane
		//TODO: should be able to do this in vertex-shader, but had interpolation artefacts
		//      (probably need to negate perspective interpolation)
		//		just do projection instead of ray-intersection
		vec3 os_eyevec = normalize( os_eyepos.xyz - v2f_pos_os.xyz );
		vec3 pos_nearclip_os = isect_RayPlane( os_eyepos.xyz, os_eyevec, cam_nearclip_plane_os );
		vec3 pos_nearclip_os_nm = 0.5f + 0.5f * pos_nearclip_os / objscale.xyz;
		out_color0 = vec4( pos_nearclip_os_nm, 1 );
	}
}
