#version 330 core

layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex0;
uniform mat4 inverse_vp;
uniform vec4 time_s;
uniform vec4 nearfar;
uniform vec4 in_ws_eyepos;
uniform vec4 in_thingy_height;
uniform vec4 midglow_fact;

in vec3 v2f_ws_eyevec;

in vec3 v2f_ws_pos;

in vec2 texcoord0;


const vec3 ws_up = vec3(0,1,0);
const float term_dist = 0.01f;
const float PI = 3.1415926536f;

vec4 sdbox( vec3 p, vec3 b ) {
	vec3  di = abs(p) - b;
	float mc = max( di.x, max(di.y, di.z) );
	float dist = min(mc, length(max(di,0.0)));
	const vec2 uv = vec2( 0.0f ); //TODO
	const float matid = 1;
	return vec4( dist, uv, matid );
}
vec4 spheredist( vec3 p, vec3 o, float r ) {
	vec3 v = p-o;
	const vec2 uv = vec2( 0, 0 ); //TODO
	float matid = 3;
	return vec4( length( v ) - r, uv, matid );
}
vec4 select( vec4 a, vec4 b ) {
	return (a.x<b.x) ? a : b;
}
vec4 select_max( vec4 a, vec4 b ) {
	return (a.x>b.x) ? a : b;
}
vec4 infcylinderdist( vec3 p, vec3 o )
{
	const vec2 uv = vec2( 0, 0 ); //TODO
	float matid = 3;
	return vec4( length(p.xz-o.xy)-o.z, uv, matid );
}

vec2 rot2d( vec2 p, float a )
{
	vec2 sc = vec2(sin(a),cos(a));
	vec2 ret;
	ret.x = dot( p, sc.yx*vec2(1,-1) );
	ret.y = dot( p, sc.xy );
	return ret;
}
vec3 mirror( vec3 p, vec3 pn_ctr, vec3 pn_norm )
{
	vec3 v0 = p-pn_ctr; 
	float dp0 = dot( v0, pn_norm );
	if ( dp0 > 0 )
		return p;
	return p - 2 * dp0 * pn_norm;
}

vec4 boxcolumn( vec3 p, vec3 siz, vec3 ctr, float m )
{
	vec3 pb = p-ctr;
	pb.y = mod( pb.y, m );
	pb.xy = rot2d( pb.xy, 45 + 2*time_s.x );
	return sdbox( pb, siz );
}

vec4 spherecolumn( vec3 p, float r, vec3 ctr, float m )
{
	vec3 pb = p-ctr;
	pb.y = mod( pb.y, m );
	return spheredist( pb, vec3(0,0.5*m,0), r );
}

float opBlend( float d1, float d2 )
{
    float dd = smoothstep(0,1,d1-d2);
    return mix(d1,d2,dd);
}

vec4 scene( vec3 p )
{
	vec3 p_org = p;

	p = mirror( p, vec3(0,50,0), vec3(1,0,0) );
	p = mirror( p, vec3(0,50,0), vec3(0,1,0) );
	p = mirror( p, vec3(0,50,0), vec3(0,0,1) );
	p.xz = rot2d( p.xz, 0.05*p.y );

	float pt = abs(in_thingy_height.x - p_org.y );
	pt = min( pt, 30 );
	p.xz += 0.1 * p.xz*pt;

	float gscl = 1.65f;
	p = p / gscl;
	
	vec4 d = vec4( nearfar.y, 0.0f, 0.0f, -1.0f ); //note: background

	vec2 c0 = rot2d( vec2(1,1),  0.09*p.y + 1.1f * time_s.x );
	vec2 c1 = rot2d( vec2(1,1), -0.13*p.y + 0.3f * time_s.x );
	vec4 db0 = boxcolumn( p, 1.6f*vec3(8, 9, 4),   vec3( 7*c0.x, 1,  7*c0.y )   + vec3(0,  11*time_s.x,0), 12 );
	vec4 db1 = boxcolumn( p, 0.7f*vec3(7, 11, 10), vec3(-17*c0.x, 5, -7*c0.y )  + vec3(0,  20*time_s.x,0), 15 );
	vec4 db2 = boxcolumn( p, 2.0f*vec3(6, 7, 7),   vec3( 2*c1.x, 1,  2*c1.y )   + vec3(0, -17*time_s.x,0), 13 );
	vec4 db3 = boxcolumn( p, 1.3f*vec3(5, 12, 3),  vec3(-10*c1.x, 3, -10*c1.y ) + vec3(0,  13*time_s.x,0), 16 );
	vec4 dbb = select( select( db0, db1 ), select( db2, db3 ) );
	dbb.w = pt;
	return dbb * gscl;

	// const vec3 sphere_ctr = vec3( 0, 28, 0 );
	// const float sphere_rad = 25;
	// vec3 ps0 = vec3(p.x, mod(p.y, 55 ), p.z );
	// vec3 ps1 = vec3(p.x, mod(p.y+25, 55 ), p.z );
	// vec4 ds0 = spheredist( ps0, sphere_ctr, sphere_rad );
	// vec4 ds1 = spheredist( ps1, sphere_ctr, sphere_rad );
	// vec4 ds = select( ds0, ds1 );


	// float thickness = 1.35f; //TODO: input
	// float th = thickness;
	// float t = abs(h-p.y);
	// t = pow( t, 1.3f );
	// thickness = 1.0f; //max( 0.65, thickness - 0.01 * t );
	// vec4 sc0 = spherecolumn( p, thickness * (9+sin(0.4*p.y)),  vec3( 10*c0.x/th,  1+20*time_s.x,  7*c0.y/th ), 9 );
	// vec4 sc1 = spherecolumn( p, thickness * (11+sin(0.5*p.y)), vec3(-11*c0.x/th, 5+20*time_s.x, -10*c0.y/th ), 11 );
	// vec4 sc2 = spherecolumn( p, thickness * (7+sin(0.3*p.y)),  vec3( 12*c1.x/th, 1+20*time_s.x,  12*c1.y/th ), 15 );

	//return min( sc0, min( sc1, sc2 ) );

	// vec4 sc3 = spherecolumn( p, thickness * ( 20+1.2f*sin(0.6*sin(p.y-10*time_s.x))), vec3( 2*c1.x, 3-10*time_s.x, -2*c1.y ) , 20 );
	// vec4 sc32 = spherecolumn( p, thickness * ( 23 - 2.2f*abs( 2*sin(0.25f*p.y)) + 0.5*sin( p.y+sin(p.y) ) ), vec3( 2*c1.x, 3+10*time_s.x, -2*c1.y ) , 20 );

	// vec4 scb = select( select( sc0, sc1 ), select( sc2, sc3 ) );
	//sc3.x = opBlend( opBlend( sc0.x, sc1.x ), opBlend( sc2.x, sc3.x ) );
	
	//sc32.x = max( sc32.x, dbb.x );
	
	// return sc32;
	//return scb;

	// const float cyl_siz = 20.0f;
	// const vec2 cyl_ctr = vec2(0,0);
	// vec3 pcyl = p;
	// vec4 dc = infcylinderdist( pcyl, vec3(cyl_ctr, cyl_siz) );

	// float m0 = min( db0.x, db1.x );
	// float m1 = min( db2.x, db3.x );
	// float mb = min( m0, m1 );

	// d.x = max( scb.x, -db3.x );
	//d.x = max( scb.x, dc.x );
	//d.x = max( d.x, -mb );
	//d.x = max( dc.x, -d.x );
	//d.x = max( ds.x, -d.x );

	//return d;
}

// ====
vec3 grad( vec3 p, float d )
{
	const vec3 eps = vec3( 60*term_dist, 0, 0 );
	return normalize( vec3( scene( p + eps.xyz ).x - d,
							scene( p + eps.zxy ).x - d,
							scene( p + eps.yzx ).x - d ) );
}

float topReflect( vec3 norm, vec3 dir )
{
	float v = step( norm.x, norm.y ) * step( norm.z, norm.y );
	const float falloff = 5;
	const float intensity = 3;
	float fresnel = pow( 1 - dot( norm, -dir ), falloff ); //TODO: schlick
	return (0.15+v) * fresnel * intensity;
	return 0;
}

vec3 get_material_col( vec4 d )
{
	return vec3( 0 );
}

//note: mostly used thingy...
//[0;1]
float rand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

void main()
{
	vec3 ws_eyevec = normalize( v2f_ws_eyevec );

	//note: jitter... something...
	float rnd = rand( gl_FragCoord.xy + 0.01f * time_s.x );

	float near_clip = nearfar.x;
	float far_clip = nearfar.y;
	float far_clipsq = far_clip * far_clip;

	vec3 dir = normalize( ws_eyevec );

	vec3 ws_eyepos = in_ws_eyepos.xyz;

	vec3 p = v2f_ws_pos; //note: use front-face of geom as initial position

	int i=0;
	vec4 d;
	const int num_iterations = 256;
	float rdt = 0;
	float sumd = 0;
	for ( i=0; i<num_iterations; ++i )
	{
		d = scene( p );
		sumd += d.x;
		if ( (d.x < term_dist ) || (rdt > 0.25*far_clip) ) {
			break;
		}
		else {
			//note: factor to compensate for distorted space, actual dist < dist - could use gradient-approximation instead? (see iq)
			//note: max to limit min-step
			float dt = max( 2*term_dist, d.x * 0.1f );
			p += dir * dt;
			rdt += dt;
		}
	}

//ooh, look, free shading... ao... something...
//float avgdist = sumd / float(i);
//float ao = clamp( avgdist / 25.0f, 0, 1 );
//outcol0 = vec4( vec3(ao), 1 );
//return;

	vec3 norm = grad( p, d.x );

	float term = step( d.x, term_dist );
	// if( term < 0.5f ) {
		// discard;
	// }

	outcol0 = vec4( 0, 0, 0, term );

	float its = midglow_fact.x * pow( clamp( 1 - abs(d.w) / 60, 0, 1 ), 2 );
	its *= term;
	outcol0.rgb += vec3( its );
//outcol0 = vec4( vec3( its ), term );
//return;
	
	//note: top-reflection
	outcol0.rgb += term * vec3( topReflect( norm, dir ) );


	//TODO: reduce glow on line-line dist?
	//TODO: or just use a different kind of glow
	//note: iteration-glow

	//vec3 glowcol = vec3( 0.5f, 0.25f, 0.85f );

	float iterations = float(i) / float( num_iterations );
	iterations = clamp( iterations-0.2, 0, 1 );
	outcol0.rgb += 2 * vec3(iterations);
	
	//TODO
	//gl_FragDepth = 
}
