#version 330 core

#define NO_LIGHTING 1
// #define CALCULATE_DEPTH
// #define DIRECTIONAL_LIGHT

uniform sampler3D densityTex;
uniform sampler3D lightTex;

uniform sampler2D frontFacesTex;
uniform sampler2D backFacesTex;
//uniform sampler2D background;
//uniform sampler2D geomDepthTex;

uniform vec4 wsStepLength;					// VALUE="0.004685" MIN="0.010000" MAX="0.000000"
uniform vec4 emissionCrossSection;			// VALUE="35.000000" MIN="0.000000" MAX="100.000000"
uniform vec4 scatteringCrossSection;		// VALUE="5.000000" MIN="0.000000" MAX="100.000000"
uniform vec4 phaseAnisotropy;				// VALUE="0.000000" MIN="-1.000000" MAX="1.000000"
uniform vec4 absorptionCrossSection;		// VALUE="36.000000" MIN="0.000000" MAX="100.000000"

uniform mat4 voxelToWorld;
uniform mat4 voxelToView;
//uniform mat4 inverseProjection;

uniform vec4 wsLightPos; 	// vec3( 10, 10, 10, 1 )
uniform vec4 wsLightDir; 	// vec3( 0, 0, 0, 0 )
uniform vec4 lightColor; 	// vec4( 1, 1, 1, 1 )
uniform vec4 shadowColor;	// vec4( 0, 0, 0, 1 )

uniform vec4 currentTime;

uniform vec4 densityParms;
// uniform float densityBias;		// VALUE="-0.100000" MIN="-1.000000" MAX="0.000000"
// uniform float densityExponent;	// VALUE="1.000000" MIN="-1.000000" MAX="1.000000"
// uniform float densityClip;		// VALUE="0.100000" MIN="-1.000000" MAX="1.000000"
float densityBias;
float densityExponent;
float densityClip;


in vec2 texcoord0_nm;

layout(location = 0, index = 0) out vec4 outcol;

//////////////////////////////////////////////////////////////////////////

const float TRANSMITTANCE_THRESHOLD = 0.01f;

float remapDensity( float d )
{
	if ( d < densityClip ) return 0.0f; //TODO: convert to step
	d = pow(d - densityBias, densityExponent);
	return d;
}

float phaseFunction( vec3 w, vec3 wp, float g )
{
	// Henyey-Greenstein phase function.
	// http://www.astro.umd.edu/~jph/HG_note.pdf

	float cosTheta = dot( w, wp );
	const float oneOver4PI = 0.079577f;
	float g2 = g * g;
	float num = 1.0f - g2;
	float denom = pow( 1.0f + g2 - 2.0f * g * cosTheta, 1.5f );
	//return oneOver4PI * num / denom; // NB: remove the normalization factor 1/4PI because we're doing single scattering
	return num / denom;
}

vec3 reducedIntensity( vec4 wsSample, vec2 viewportScale, vec2 viewportOffset )
{
   return lightColor.xyz;
}

void main(void)
{
	densityBias = 10*densityParms.x;
	densityExponent = densityParms.y;
	densityClip = densityParms.z; // + (sin(4*currentTime.x) * 0.5 + 0.5);

	// find the right place to lookup in the back buffer
	//vec2 screenSpaceTextCoord = gl_FragCoord.xy; //( texcoord0.xy + vec2(1.0f)) * 0.5f;

	// entry/exit points in voxel space ===========================

	vec4 vsStart = texture( frontFacesTex, texcoord0_nm );
	vec4 vsEnd = texture( backFacesTex, texcoord0_nm );

	// discard outside box
	const float eps = 0.001f;
	if ( vsEnd.a < eps || length(vsEnd.xyz - vsStart.xyz)<eps ) {
		//outcol = vec4( 1, 0, 0, 1 ); return;
		discard;
	}

	// perform texture fetches ====================================
	//vec3 background = texture( background, screenSpaceTextCoord ).xyz;
	//float depthBuffer = texture( geomDepthTex, screenSpaceTextCoord ).r;

	// entry/exit points in world space ===========================

	vec4 wsStart = voxelToWorld * vsStart;
	vec4 wsEnd   = voxelToWorld * vsEnd;
	vec3 wsRayDir = normalize( wsEnd.xyz - wsStart.xyz );
	float wsRayLength = distance( wsEnd.xyz, wsStart.xyz );
	int numIntegrationSteps = max( 1, int( wsRayLength / wsStepLength.x) );
	float invNumIntegrationSteps = 1.0f / float(numIntegrationSteps);
	float wsRayStepLength = wsRayLength * invNumIntegrationSteps; // this is an approximation of wsStepLength for this given ray

	// ray direction in voxel space ===========================

	vec3 vsRayDir = normalize( vsEnd.xyz - vsStart.xyz ); // towards the eye
	float vsTotalLength = distance( vsEnd.xyz, vsStart.xyz );
	float vsStepLength = vsTotalLength * invNumIntegrationSteps;
	vec3 vsDirDelta = vsRayDir * vsStepLength;
	vec3 vsSamplePos = vsStart.xyz;

	// entry/exit points in eye space =============================

	vec4 esStart = voxelToView * vsStart;
	vec4 esEnd   = voxelToView * vsEnd;
	vec3 esDirDelta = ( esEnd.xyz - esStart.xyz ) * invNumIntegrationSteps;
	vec4 esSample = esStart;

	// ============================================================

	//float csGeomDepth = 2.0f * depthBuffer - 1.0f; //[0,1] -> [-1,1]

	// The ray traverses from the medium to the eye - in case of
	// overlapping geometry, we'll need to shift the end point
	// to the geometry surface by finding the first point along the
	// ray whose depth is less than the read value on the depth buffer

	//vec4 esClosestGeometry = inverseProjection * vec4( 0.0f, 0.0f, csGeomDepth, 1.0f );
	//esClosestGeometry.xyz /= esClosestGeometry.w;

	float wsTraversalLength = 0.0f;
	// if ( esClosestGeometry.z > esEnd.z ) // z pointing towards eye
	// {
		// wsTraversalLength = esClosestGeometry.z - esEnd.z; // distances in worldSpace and eyeSpace are the same (NB: unless there's camera scaling!)
		// float numSteps = ceil( wsTraversalLength / wsRayStepLength );
		// numIntegrationSteps -= int(numSteps); // readjust the number of integration step till we reach the geometry
	// }

	float totalCrossSection = absorptionCrossSection.x + scatteringCrossSection.x;

	// Calculate the attenuated light reaching the eye

// #ifdef CALCULATE_DEPTH
	// vec4 esClosestSample = esSample;
	// bool esClosestSampleSet = false;
	// vec4 csSample;
// #endif

	float densitySample;
	float totalDensity = 0.0f;
	vec3 li, lri;
	vec3 le = vec3(0.0f);
	vec3 lp = vec3(0.0f);
	float attenuation = 1.0f;
	for( int i = 0 ; i < numIntegrationSteps; i++ )
	{
		float density = texture( densityTex, vsSamplePos ).r;
		densitySample = remapDensity( density );
		//le = emissionCrossSection.xxx; // * texture( lightTex, vsSamplePos ).xxx;
		le += texture( lightTex, vsSamplePos ).xxx;

		float ndl = wsRayStepLength * densitySample;
		float opticalDepth = ndl * totalCrossSection;
		float attenuationStep = exp( -opticalDepth );

		vec4 wsSample = voxelToWorld * vec4( vsSamplePos, 1.0f);
#ifdef NO_LIGHTING
		// fake some light information, as we don't really have any. This is
		// just to prevent the volume from looking completely black
		lri = texture( lightTex, vsSamplePos ).xxx; //vec3( 1, 1, 1 ); //lightColor.xyz;
		//vec3 lri = texture( lightTex, vsSamplePos ).rrr;
#else //NO_LIGHTING
	// #ifdef DIRECTIONAL_LIGHT
		// vec3 wsFromLight = wsLightDir;
	// #else //DIRECTIONAL_LIGHT
		// // spot light
		// vec3 wsFromLight = normalize( wsSample.xyz - wsLightPos.xyz );
	// #endif //DIRECTIONAL_LIGHT
		// vec3 wsToEye = -wsRayDir;
		// float phaseValue = phaseFunction( wsFromLight, wsToEye, phaseAnisotropy.x );     
		// lri = reducedIntensity( wsSample, viewportScale, viewportOffset ) * phaseValue ;
#endif //NO_LIGHTING
		li  = (lri + shadowColor.xyz) * scatteringCrossSection.x;
		lp += ( li + le ) * ndl * attenuation ;

		totalDensity += ndl;

		vsSamplePos += vsDirDelta;
		wsTraversalLength += wsRayStepLength;
		esSample.xyz += esDirDelta;

		attenuation *= attenuationStep;

// #ifdef CALCULATE_DEPTH
		// // retrieve the closest eye-space sample by accounting only
		// // for those samples with density > 0 (actual hit with the data)
		// if ( densitySample > 0.0f && !esClosestSampleSet )
		// {
			 // esClosestSample = esSample;
			 // esClosestSampleSet = true;
		// }
// #endif
		// check for ray termination
		if ( wsTraversalLength > wsRayLength || attenuation < TRANSMITTANCE_THRESHOLD )
			break;
	}

// #ifdef CALCULATE_DEPTH
	// csSample = glm_ProjectionMatrix * esClosestSample;
	// float csSampleDepth = csSample.z / csSample.w;
	// outcol = csSampleDepth * 0.5 + 0.5; // [-1,1] -> [0,1]
// #endif
	//outcol = vec4( background * attenuation + lp, 1.0f );
	outcol = vec4( lp, 1.0f );

	//DEBUG
	//outcol = vec4( vec3(1), totalDensity ); //vec3( totalDensity), 1 );
	outcol = vec4( vec3( le ), totalDensity );
}
