#pragma OPENCL EXTENSION cl_amd_printf : enable

__kernel void LinearForce(__global float4 *positions, __global float4 *velocities, __global float4 *attributes, __global float4 *forces, float deltaTime, float4 paramOne, float4 paramTwo, int workLimit, int segmentEnd, int segmentLength)
{
	if(get_global_id(0) < workLimit)
	{
		uint index = get_global_id(0);
		if(index >= segmentEnd) index -= segmentLength;

		forces[index] += paramOne;
	}
	else return;
}