#pragma OPENCL EXTENSION cl_amd_printf : enable

float PackToFloat(unsigned int x, unsigned int y, unsigned int z)
{
	unsigned int packedColor = (x << 16) | (y << 8) | z;
	float packedFloat = (float) ( ((float)packedColor) / ((float) (1 << 24)) );  

	return packedFloat;
}

__kernel void SetColorFromLife(__global float4 *positions, __global float4 *velocities, __global float4 *attributes, __global float4 *forces, float deltaTime, float4 maxLife, float4 limiter, int workLimit, int segmentEnd, int segmentLength)
{
	if(get_global_id(0) < workLimit)
	{
		uint index = get_global_id(0);
		if(index >= segmentEnd) index -= segmentLength;

		if(attributes[index].w > 1.0) positions[index].w = PackToFloat(convert_uint(clamp( (attributes[index].x/maxLife.x), (float)0.0, (float)1.0)*255), 0, 0);
		else positions[index].w = PackToFloat(convert_uint(255 ), 0, 0);
	}
	else return;
}