#version 150
#extension GL_ARB_explicit_attrib_location : enable

in vec3 gSpine;
in vec2 uv;

out vec4 outColor;

uniform sampler2D Depth;
uniform sampler2D TexStroke;

uniform float angleShading;
uniform vec3 edgeColour;

in float edgeType;
in float angle;

in float gDist;
uniform float edgeWidth;

void main(void)
{
	//if(texture2D(TexStroke, uv).a < 0.9f) discard;
    vec2 texCoord = (gSpine.xy + 1.0) / 2.0;
    float depth = texture2D(Depth, texCoord).r;
	depth -= 0.0000001;
	if (depth < gl_FragCoord.z)
        discard;

		
	float alpha = 1.0;
	/*
    float d = abs(gDist);
    float tipLength = 1.2 * fwidth(d);
    if (d > edgeWidth - tipLength)
    alpha = 1.0 - (d - edgeWidth + tipLength) / tipLength;
	*/
	
	
	float angleShadingFactor = clamp(angle*angleShading, 0.0, 1.0);
	vec3 color = edgeColour*angleShadingFactor;
	float Gamma = 2.2f;
	color = pow(color.xyz, vec3(Gamma));

    outColor = vec4(color, alpha);
}