#version 150
#extension GL_ARB_explicit_attrib_location : enable
layout(triangles_adjacency) in;
layout(triangle_strip, max_vertices = 24) out;

//<u>
uniform mat4 mMat;
uniform mat4 vMat;
uniform mat4 pMat;
uniform mat4 mvpMat;
//</u>

const float bf = 0;
bool IsFront(vec3 A, vec3 B, vec3 C)
{
    float area = (A.x * B.y - B.x * A.y) + (B.x * C.y - C.x * B.y) + (C.x * A.y - A.x * C.y);
    return area > bf;
}
bool IsBack(vec3 A, vec3 B, vec3 C)
{
    float area = (A.x * B.y - B.x * A.y) + (B.x * C.y - C.x * B.y) + (C.x * A.y - A.x * C.y);
    return area < bf;
}

uniform float edgeWidth;
uniform float edgeOverhang;
uniform float creaseThreshold;
uniform float renderSilhouettes;

out vec3 gSpine;
out float edgeType;
out vec2 uv;
out float angle;

uniform float distanceFromCamera;

const float twoPi = 6.28318;

vec2 mC;

float zz;

out float gDist;

void EmitEdge(vec3 P0, vec3 P1, float edgeT)
{
	if(P0.x < -1.0) return;
	if(P0.y < -1.0) return;
	if(P1.x < -1.0) return;
	if(P1.y < -1.0) return;
	if(P0.x > 1.0) return;
	if(P0.y > 1.0) return;
	if(P1.x > 1.0) return;
	if(P1.y > 1.0) return;
	
	/*
	P0.x = min(P0.x, 0.0f);
	P0.y = min(P0.y, 0.0f);
	P1.x = min(P1.x, 0.0f);
	P1.y = min(P1.y, 0.0f);
	*/

	float edgeWidthTwo = edgeWidth/(distanceFromCamera/15.0f);
	edgeWidthTwo = clamp(edgeWidthTwo, edgeWidth*0.5f, edgeWidth+(edgeWidth*0.3f)); 

	vec2 v0 = P0.xy - mC;
	v0 = normalize(v0);
	vec2 v1 = P1.xy - mC;
	v1 = normalize(v1);

	float d0 = length(v0);
	float a0 = atan(v0.y, v0.x);

	float d1 = length(v1);
	float a1 = atan(v1.y, v1.x);

	float u0 = a0/twoPi;
	float u1 = a1/twoPi;


    vec3  E = edgeOverhang * vec3(P1.xy - P0.xy, 0);
    vec2  V = normalize(E.xy);
    vec3  N = vec3(-V.y, V.x, 0) * edgeWidthTwo * zz;
    vec3  S = -N;

	edgeType = edgeT;

	gSpine = P1;
	gDist = edgeWidthTwo;
 	gl_Position = vec4(P1 + S + E, 1); 
	uv = vec2(u1, 1.0);
	EmitVertex();

	gDist = -edgeWidthTwo;
    gl_Position = vec4(P1 + N + E, 1);
	uv = vec2(u1, 0.0); 
	EmitVertex();

	gDist = edgeWidthTwo;
    gSpine = P0;
    gl_Position = vec4(P0 + S - E, 1); 
	uv = vec2(u0, 1.0);
	EmitVertex();

	gDist = -edgeWidthTwo;
 	gl_Position = vec4(P0 + N - E, 1); 
	uv = vec2(u0, 0.0);
	EmitVertex();

    EndPrimitive();
}

void main()
{
	//temp /= temp.w;
	//mC = temp.xy;

    vec4 v0 = mMat*gl_in[0].gl_Position;
    vec4 v1 = mMat*gl_in[1].gl_Position;
    vec4 v2 = mMat*gl_in[2].gl_Position;
    vec4 v3 = mMat*gl_in[3].gl_Position;
    vec4 v4 = mMat*gl_in[4].gl_Position;
    vec4 v5 = mMat*gl_in[5].gl_Position;

	vec3 fZeroNormal = normalize(cross(v2.xyz - v0.xyz, v4.xyz - v0.xyz));
	vec3 fOneNormal = normalize(cross(v1.xyz - v0.xyz, v2.xyz - v0.xyz));
	vec3 fTwoNormal = normalize(cross(v3.xyz - v2.xyz, v4.xyz - v2.xyz));
	vec3 fThreeNormal = normalize(cross(v4.xyz - v0.xyz, v5.xyz - v0.xyz));
	
	//vec4 a = vMat * v0;
	//zz = (a.z/a.w)*1000;

	vec4 p0 = pMat*vMat*v0;
	p0 /= p0.w;
	zz = 1.0;//;p0.z;
	vec4 p1 = pMat*vMat*v1;
	p1 /= p1.w;
	vec4 p2 = pMat*vMat*v2;
	p2 /= p2.w;
	vec4 p3 = pMat*vMat*v3;
	p3 /= p3.w;
	vec4 p4 = pMat*vMat*v4;
	p4 /= p4.w;
	vec4 p5 = pMat*vMat*v5;
	p5 /= p5.w;

	
	//Crease edges
	float iAngleOne = acos(dot(fZeroNormal, fOneNormal));
	float iAngleTwo = acos(dot(fZeroNormal, fTwoNormal));
	float iAngleThree = acos(dot(fZeroNormal, fThreeNormal));
	
	if(iAngleOne > creaseThreshold)
	{
	angle = iAngleOne;
	 EmitEdge(p0.xyz, p2.xyz, -1.0);
	 }
	 if(iAngleTwo > creaseThreshold)
	{
	angle = iAngleTwo;
	 EmitEdge(p2.xyz, p4.xyz, -1.0);
	 }
	 if(iAngleThree > creaseThreshold)
	{
	angle = iAngleThree;
	EmitEdge(p4.xyz, p0.xyz, -1.0);
	 }
	 

	//Silhouette edges
	if(renderSilhouettes > 0.5)
	{
		angle = 2.0;
		if (IsFront(p0.xyz, p2.xyz, p4.xyz))
		{
			if (IsBack(p0.xyz, p1.xyz, p2.xyz)) EmitEdge(p0.xyz, p2.xyz, 1.0);
			if (IsBack(p2.xyz, p3.xyz, p4.xyz)) EmitEdge(p2.xyz, p4.xyz, 1.0);
			if (IsBack(p0.xyz, p4.xyz, p5.xyz)) EmitEdge(p4.xyz, p0.xyz, 1.0);
		} 
	}
}