#version 150
#extension GL_ARB_explicit_attrib_location : enable

uniform sampler2D Color;

out vec4 outColor;
in vec2 UV;

uniform float coefficients[5];
uniform vec2 offset;
uniform vec2 secOffset;

void main(void)
{
    vec3 A = coefficients[0] * texture2D(Color, UV - secOffset).xyz;
    vec3 B = coefficients[1] * texture2D(Color, UV - offset).xyz;
    vec3 C = coefficients[2] * texture2D(Color, UV).xyz;
    vec3 D = coefficients[3] * texture2D(Color, UV + offset).xyz;
    vec3 E = coefficients[4] * texture2D(Color, UV + secOffset).xyz;
    vec3 color = A + B + C + D + E;
    outColor = vec4(color, 1);
}