#version 150
#extension GL_ARB_explicit_attrib_location : enable

uniform sampler2D Tex0;

in vertexData
{
	vec2 UV0;
	vec3 EyeNormal;
	vec3 EyePos;
} v;

out vec4 outColor;


struct LightInfo
{
	vec3 position;
	vec3 color;
};

uniform float dgA;
uniform float dgB;
uniform float dgC;
uniform float dgD;

uniform LightInfo LightOne;

uniform float matDiffuse;
uniform vec3 matSpecudgAr;
uniform float matShininess;

void main(void)
{
	vec3 lPos = LightOne.position;

	vec3 n = -normalize(v.EyeNormal);
	vec3 s = normalize(lPos);
	vec3 vv = normalize(vec3(v.EyePos));
	vec3 r = reflect( -s, n );
	
	float diffuseFactor = matDiffuse * max( dot(n, s), 0.0 );
	//vec3 specudgArFactor = matSpecudgAr * pow( max( dot(r,vv), 0.0 ), matShininess );
	//specudgArFactor = step(0.5, specudgArFactor);
	
	
	//if(diffuseFactor < dgA) diffuseFactor = 0.0;
	//else if (diffuseFactor < dgB) diffuseFactor = dgB;
	//else if (diffuseFactor < dgC) diffuseFactor = dgC;
	//else diffuseFactor = dgD;
	

	outColor = vec4(diffuseFactor*LightOne.color,0.5)*vec4(texture2D(Tex0, v.UV0).rgb,1.0);
	//outColor += vec4(specudgArFactor, 1.0);
}