#version 150
#extension GL_ARB_explicit_attrib_location : enable
layout( points ) in;
layout( triangle_strip, max_vertices = 32 ) out;

struct LightInfo
{
	vec3 position;
	vec3 color;
};
LightInfo LightOne;

const float halfSize = 1;
uniform mat4 pMat;
uniform mat4 cMat;
uniform mat4 iMat;
out vec2 TexCoord;

out vec3 colOut;

bool visible(vec3 v0, vec3 v1, vec3 v2, vec3 lightPos)
{
	vec3 normal = cross(v1 - v0, v2 - v0);
	float d = dot(v0, normal);
	return (dot(lightPos, normal) - d < 0);
}

in vec3 pos[];

void main()
{
vec4 lightPos = vec4(10, 4.0, 20, 1.0);
vec4 lightPosCamera = cMat * lightPos;

vec4 partPos = vec4(-5,1.0,15,1.0);
vec4 partPosCamera = cMat * partPos;

//Vis Light
{
vec4 light[4];
const float lightSize = 0.50;
light[0] = vec4(-lightSize,-lightSize,0.0,0.0) + lightPosCamera;
light[1] = vec4(lightSize,-lightSize,0.0,0.0) + lightPosCamera;
light[2] = vec4(-lightSize,lightSize,0.0,0.0) + lightPosCamera;
light[3] = vec4(lightSize,lightSize,0.0,0.0) + lightPosCamera;
for(int i=0 ;i<4 ; i++) light[i] = pMat * light[i];
colOut = vec3(0.0, 1.0, 1.0);
gl_Position = light[0];
EmitVertex();
gl_Position = light[1];
EmitVertex();
gl_Position = light[2];
EmitVertex();
gl_Position = light[3];
EmitVertex();
EndPrimitive();
}


//Vis Particle
{
vec4 part[4];
const float partSize = 0.50;
part[0] = vec4(-partSize,-partSize,0.0,0.0) + partPosCamera;
part[1] = vec4(partSize,-partSize,0.0,0.0) + partPosCamera;
part[2] = vec4(-partSize,partSize,0.0,0.0) + partPosCamera;
part[3] = vec4(partSize,partSize,0.0,0.0) + partPosCamera;
for(int i=0 ;i<4 ; i++) part[i] = pMat * part[i];
colOut = vec3(0.0, 1.0, 0.0);
gl_Position = part[0];
EmitVertex();
gl_Position = part[1];
EmitVertex();
gl_Position = part[2];
EmitVertex();
gl_Position = part[3];
EmitVertex();
EndPrimitive();
}





vec4 volume[4];

const float halfSize = 1.0;
volume[0] = (cMat*vec4(-halfSize,0.0,-halfSize,1.0)) + partPosCamera;
volume[1] = (cMat*vec4(halfSize,0.0,-halfSize,1.0)) + partPosCamera;
volume[2] = (cMat*vec4(-halfSize,0.0,halfSize,1.0)) + partPosCamera;
volume[3] = (cMat*vec4(halfSize,0.0,halfSize,1.0)) + partPosCamera;

vec4 exVolume[4];
const float ext = 1e7;
for(int i=0 ; i<4 ; i++)
{
	vec4 lightDir = volume[i] - lightPosCamera;
	exVolume[i] = lightPosCamera + lightDir * ext;
}

/*
if(!visible(volume[0].xyz, volume[1].xyz, volume[2].xyz, lightPos.xyz))
colOut = vec3(0.1, 0.0, 0.0);
else colOut = vec3(0.0, 0.1, 0.0);
*/





for(int i=0 ;i<4 ; i++) volume[i] = pMat * volume[i];
for(int i=0 ;i<4 ; i++) exVolume[i] = pMat * exVolume[i];

/*
colOut = vec3(1.0, 0.0, 0.0);
//Front cap
gl_Position = volume[0];
EmitVertex();
gl_Position = volume[1];
EmitVertex();
gl_Position = volume[2];
EmitVertex();
gl_Position = volume[3];
EmitVertex();
EndPrimitive();


//Back cap
colOut = vec3(1,1,0);
gl_Position = exVolume[0];
EmitVertex();
gl_Position = exVolume[1];
EmitVertex();
gl_Position = exVolume[2];
EmitVertex();
gl_Position = exVolume[3];
EmitVertex();
EndPrimitive();





colOut = vec3(0.1,0,0.1);

/*
//Back
colOut = vec3(0.1,0,0.1);
gl_Position = volume[0];
EmitVertex();
gl_Position = volume[1];
EmitVertex();
gl_Position = exVolume[0];
EmitVertex();
gl_Position = exVolume[1];
EmitVertex();
EndPrimitive();


/*
//Front
gl_Position = volume[2];
EmitVertex();
gl_Position = volume[3];
EmitVertex();
gl_Position = exVolume[2];
EmitVertex();
gl_Position = exVolume[3];
EmitVertex();
EndPrimitive();
*/




//Left
/*
gl_Position = volume[0];
EmitVertex();
gl_Position = volume[2];
EmitVertex();
gl_Position = exVolume[0];
EmitVertex();
gl_Position = exVolume[2];
EmitVertex();
EndPrimitive();


/*
//Right
gl_Position = volume[1];
EmitVertex();
gl_Position = volume[3];
EmitVertex();
gl_Position = exVolume[1];
EmitVertex();
gl_Position = exVolume[3];
EmitVertex();
EndPrimitive();
*/



}